#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=7.0', ]

test_requirements = [ ]

setup(
    author="Lauren Mak",
    author_email='laurenmak93@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Minimum viable module for the de novo assembly stage of metagenomics analysis.",
    entry_points={
        'console_scripts': [
            'cap2_assembly=cap2_assembly.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='cap2_assembly',
    name='cap2_assembly',
    packages=find_packages(include=['cap2_assembly', 'cap2_assembly.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/lauren-mak/cap2_assembly',
    version='0.1.0',
    zip_safe=False,
)
