"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizer = void 0;
const core_1 = require("@aws-cdk/core");
const method_1 = require("./method");
const AUTHORIZER_SYMBOL = Symbol.for('@aws-cdk/aws-apigateway.Authorizer');
/**
 * Base class for all custom authorizers
 */
class Authorizer extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.authorizationType = method_1.AuthorizationType.CUSTOM;
        Object.defineProperty(this, AUTHORIZER_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x) {
        return x !== null && typeof (x) === 'object' && AUTHORIZER_SYMBOL in x;
    }
}
exports.Authorizer = Authorizer;
//# sourceMappingURL=data:application/json;base64,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