"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonSchemaType = exports.JsonSchemaVersion = void 0;
var JsonSchemaVersion;
(function (JsonSchemaVersion) {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     */
    JsonSchemaVersion["DRAFT4"] = "http://json-schema.org/draft-04/schema#";
    JsonSchemaVersion["DRAFT7"] = "http://json-schema.org/draft-07/schema#";
})(JsonSchemaVersion = exports.JsonSchemaVersion || (exports.JsonSchemaVersion = {}));
var JsonSchemaType;
(function (JsonSchemaType) {
    JsonSchemaType["NULL"] = "null";
    JsonSchemaType["BOOLEAN"] = "boolean";
    JsonSchemaType["OBJECT"] = "object";
    JsonSchemaType["ARRAY"] = "array";
    JsonSchemaType["NUMBER"] = "number";
    JsonSchemaType["INTEGER"] = "integer";
    JsonSchemaType["STRING"] = "string";
})(JsonSchemaType = exports.JsonSchemaType || (exports.JsonSchemaType = {}));
//# sourceMappingURL=data:application/json;base64,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