"use strict";
const apigateway = require("../lib");
module.exports = {
    'if jsonWithStandardFields method called with no parameter'(test) {
        const testFormat = apigateway.AccessLogFormat.jsonWithStandardFields();
        test.deepEqual(testFormat.toString(), '{"requestId":"$context.requestId","ip":"$context.identity.sourceIp","user":"$context.identity.user","caller":"$context.identity.caller","requestTime":"$context.requestTime","httpMethod":"$context.httpMethod","resourcePath":"$context.resourcePath","status":"$context.status","protocol":"$context.protocol","responseLength":"$context.responseLength"}');
        test.done();
    },
    'if jsonWithStandardFields method called with all parameters false'(test) {
        const testFormat = apigateway.AccessLogFormat.jsonWithStandardFields({
            caller: false,
            httpMethod: false,
            ip: false,
            protocol: false,
            requestTime: false,
            resourcePath: false,
            responseLength: false,
            status: false,
            user: false,
        });
        test.deepEqual(testFormat.toString(), '{"requestId":"$context.requestId"}');
        test.done();
    },
    'if clf method called'(test) {
        const testFormat = apigateway.AccessLogFormat.clf();
        test.deepEqual(testFormat.toString(), '$context.identity.sourceIp $context.identity.caller $context.identity.user [$context.requestTime] "$context.httpMethod $context.resourcePath $context.protocol" $context.status $context.responseLength $context.requestId');
        test.done();
    },
    'if custom method called'(test) {
        const testFormat = apigateway.AccessLogFormat.custom(JSON.stringify({
            requestId: apigateway.AccessLogField.contextRequestId(),
            sourceIp: apigateway.AccessLogField.contextIdentitySourceIp(),
            method: apigateway.AccessLogField.contextHttpMethod(),
            accountId: apigateway.AccessLogField.contextAccountId(),
            userContext: {
                sub: apigateway.AccessLogField.contextAuthorizerClaims('sub'),
                email: apigateway.AccessLogField.contextAuthorizerClaims('email'),
            },
        }));
        test.deepEqual(testFormat.toString(), '{"requestId":"$context.requestId","sourceIp":"$context.identity.sourceIp","method":"$context.httpMethod","accountId":"$context.identity.accountId","userContext":{"sub":"$context.authorizer.claims.sub","email":"$context.authorizer.claims.email"}}');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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