"use strict";
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const apigw = require("../lib");
module.exports = {
    'integration "credentialsRole" and "credentialsPassthrough" are mutually exclusive'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'MyRole', { assumedBy: new iam.ServicePrincipal('foo') });
        // THEN
        test.throws(() => new apigw.Integration({
            type: apigw.IntegrationType.AWS_PROXY,
            options: {
                credentialsPassthrough: true,
                credentialsRole: role,
            },
        }), /'credentialsPassthrough' and 'credentialsRole' are mutually exclusive/);
        test.done();
    },
    'integration connectionType VpcLink requires vpcLink to be set'(test) {
        test.throws(() => new apigw.Integration({
            type: apigw.IntegrationType.HTTP_PROXY,
            integrationHttpMethod: 'ANY',
            options: {
                connectionType: apigw.ConnectionType.VPC_LINK,
            },
        }), /'connectionType' of VPC_LINK requires 'vpcLink' prop to be set/);
        test.done();
    },
    'connectionType of INTERNET and vpcLink are mutually exclusive'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const vpc = new ec2.Vpc(stack, 'VPC');
        const nlb = new elbv2.NetworkLoadBalancer(stack, 'NLB', {
            vpc,
        });
        const link = new apigw.VpcLink(stack, 'link', {
            targets: [nlb],
        });
        // THEN
        test.throws(() => new apigw.Integration({
            type: apigw.IntegrationType.HTTP_PROXY,
            integrationHttpMethod: 'ANY',
            options: {
                connectionType: apigw.ConnectionType.INTERNET,
                vpcLink: link,
            },
        }), /cannot set 'vpcLink' where 'connectionType' is INTERNET/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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