"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, VPC, subnet, securityGroup, bucketName, url, user, password) {
        super(scope, id);
        this.flywayLambdaMigration = new awsLambda.Function(this, 'flywayLambdaMigration', {
            vpc: VPC,
            vpcSubnets: subnet,
            securityGroups: [securityGroup],
            allowPublicSubnet: true,
            memorySize: 512,
            timeout: cdk.Duration.seconds(30),
            handler: 'flywayjar.Main::handleRequest',
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                url: url,
                bucketName: bucketName,
                user: user,
                password: password,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, 'test', 'arn:aws:s3:::flywaymigrationconstruct'), 'flywayjar.zip'),
        });
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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