# Content sectioning
from webcompy.elements.html.html_tags import (
    ADDRESS,
    ARTICLE,
    ASIDE,
    FOOTER,
    HEADER,
    H1,
    H2,
    H3,
    H4,
    H5,
    H6,
    MAIN,
    NAV,
    SECTION,
)

# Text content
from webcompy.elements.html.html_tags import (
    BLOCKQUOTE,
    DD,
    DIV,
    DL,
    DT,
    FIGCAPTION,
    FIGURE,
    HR,
    LI,
    MENU,
    OL,
    P,
    PRE,
    UL,
)

# Inline text semantics
from webcompy.elements.html.html_tags import (
    TEXT,
    A,
    ABBR,
    B,
    BDI,
    BDO,
    BR,
    CITE,
    CODE,
    DATA,
    DFN,
    EM,
    I,
    KBD,
    MARK,
    Q,
    RP,
    RT,
    RUBY,
    S,
    SAMP,
    SMALL,
    SPAN,
    STRONG,
    SUB,
    SUP,
    TIME,
    U,
    VAR,
    WBR,
)

# Image and multimedia
from webcompy.elements.html.html_tags import AREA, AUDIO, IMG, MAP, TRACK, VIDEO

# Embedded content
from webcompy.elements.html.html_tags import (
    EMBED,
    IFRAME,
    OBJECT,
    PARAM,
    PICTURE,
    PORTAL,
    SOURCE,
)

# SVG and MathML
from webcompy.elements.html.html_tags import SVG, MATH

# Scripting
from webcompy.elements.html.html_tags import CANVAS

# Demarcating edits
from webcompy.elements.html.html_tags import DEL, INS

# Table content
from webcompy.elements.html.html_tags import (
    CAPTION,
    COL,
    COLGROUP,
    TABLE,
    TBODY,
    TD,
    TFOOT,
    TH,
    THEAD,
    TR,
)

# Forms
from webcompy.elements.html.html_tags import (
    BUTTON,
    DATALIST,
    FIELDSET,
    FORM,
    INPUT,
    LABEL,
    LEGEND,
    METER,
    OPTGROUP,
    OPTION,
    OUTPUT,
    PROGRESS,
    SELECT,
    TEXTAREA,
)

# Interactive elements
from webcompy.elements.html.html_tags import (
    DETAILS,
    DIALOG,
    SUMMARY,
)


__all__ = [
    "ADDRESS",
    "ARTICLE",
    "ASIDE",
    "FOOTER",
    "HEADER",
    "H1",
    "H2",
    "H3",
    "H4",
    "H5",
    "H6",
    "MAIN",
    "NAV",
    "SECTION",
    "BLOCKQUOTE",
    "DD",
    "DIV",
    "DL",
    "DT",
    "FIGCAPTION",
    "FIGURE",
    "HR",
    "LI",
    "MENU",
    "OL",
    "P",
    "PRE",
    "UL",
    "TEXT",
    "A",
    "ABBR",
    "B",
    "BDI",
    "BDO",
    "BR",
    "CITE",
    "CODE",
    "DATA",
    "DFN",
    "EM",
    "I",
    "KBD",
    "MARK",
    "Q",
    "RP",
    "RT",
    "RUBY",
    "S",
    "SAMP",
    "SMALL",
    "SPAN",
    "STRONG",
    "SUB",
    "SUP",
    "TIME",
    "U",
    "VAR",
    "WBR",
    "AREA",
    "AUDIO",
    "IMG",
    "MAP",
    "TRACK",
    "VIDEO",
    "EMBED",
    "IFRAME",
    "OBJECT",
    "PARAM",
    "PICTURE",
    "PORTAL",
    "SOURCE",
    "SVG",
    "MATH",
    "CANVAS",
    "DEL",
    "INS",
    "CAPTION",
    "COL",
    "COLGROUP",
    "TABLE",
    "TBODY",
    "TD",
    "TFOOT",
    "TH",
    "THEAD",
    "TR",
    "BUTTON",
    "DATALIST",
    "FIELDSET",
    "FORM",
    "INPUT",
    "LABEL",
    "LEGEND",
    "METER",
    "OPTGROUP",
    "OPTION",
    "OUTPUT",
    "PROGRESS",
    "SELECT",
    "TEXTAREA",
    "DETAILS",
    "DIALOG",
    "SUMMARY",
]
