"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../");
const core_1 = require("@aws-cdk/core");
const path = require("path");
require("@aws-cdk/assert/jest");
test('create the ServerlessAPI', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    new __1.ServerlessApi(stack, 'testing', {
        brefLayerVersion: 'arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:11',
        lambdaCodePath: path.join(__dirname, '../../codebase'),
    });
    expect(stack).toHaveResource('AWS::ApiGatewayV2::Api');
    expect(stack).toHaveResource('AWS::Lambda::Function');
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXgudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy90ZXN0L2luZGV4LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSwyQkFBb0M7QUFDcEMsd0NBQTJDO0FBQzNDLDZCQUE2QjtBQUM3QixnQ0FBOEI7QUFFOUIsSUFBSSxDQUFDLDBCQUEwQixFQUFFLEdBQUcsRUFBRTtJQUNwQyxNQUFNLE9BQU8sR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0lBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUMsQ0FBQztJQUVsRCxJQUFJLGlCQUFhLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtRQUNsQyxnQkFBZ0IsRUFBRSxnRUFBZ0U7UUFDbEYsY0FBYyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLGdCQUFnQixDQUFDO0tBQ3ZELENBQUMsQ0FBQztJQUVILE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxjQUFjLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUN2RCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLHVCQUF1QixDQUFDLENBQUM7QUFDeEQsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTZXJ2ZXJsZXNzQXBpIH0gZnJvbSAnLi4vJztcbmltcG9ydCB7IEFwcCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgJ0Bhd3MtY2RrL2Fzc2VydC9qZXN0JztcblxudGVzdCgnY3JlYXRlIHRoZSBTZXJ2ZXJsZXNzQVBJJywgKCkgPT4ge1xuICBjb25zdCBtb2NrQXBwID0gbmV3IEFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBTdGFjayhtb2NrQXBwLCAndGVzdGluZy1zdGFjaycpO1xuXG4gIG5ldyBTZXJ2ZXJsZXNzQXBpKHN0YWNrLCAndGVzdGluZycsIHtcbiAgICBicmVmTGF5ZXJWZXJzaW9uOiAnYXJuOmF3czpsYW1iZGE6YXAtbm9ydGhlYXN0LTE6MjA5NDk3NDAwNjk4OmxheWVyOnBocC03NC1mcG06MTEnLFxuICAgIGxhbWJkYUNvZGVQYXRoOiBwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vLi4vY29kZWJhc2UnKSxcbiAgfSk7XG5cbiAgZXhwZWN0KHN0YWNrKS50b0hhdmVSZXNvdXJjZSgnQVdTOjpBcGlHYXRld2F5VjI6OkFwaScpO1xuICBleHBlY3Qoc3RhY2spLnRvSGF2ZVJlc291cmNlKCdBV1M6OkxhbWJkYTo6RnVuY3Rpb24nKTtcbn0pO1xuXG5cblxuIl19