"""Initial

Peek Plugin Database Migration Script

Revision ID: 64309a77b48d
Revises: 
Create Date: 2017-07-13 16:22:26.973631

"""

# revision identifiers, used by Alembic.
revision = '64309a77b48d'
down_revision = None
branch_labels = None
depends_on = None


from sqlalchemy.dialects.mssql.base import MSDialect
from sqlalchemy.dialects.postgresql.base import PGDialect
from sqlalchemy.schema import Sequence, CreateSequence
from alembic import op
import sqlalchemy as sa
import geoalchemy2


def isMssqlDialect():
    return isinstance(op.get_bind().engine.dialect, MSDialect)

def isPostGreSQLDialect():
    return isinstance(op.get_bind().engine.dialect, PGDialect)

def nextval(seqName):
    if isMssqlDialect():
        return sa.text('(NEXT VALUE FOR "pl_livedb"."%s")' % seqName)

    return sa.text('nextval(\'pl_livedb."%s"\')' % seqName)

def upgrade():
    op.execute(CreateSequence(Sequence('LiveDbItem_id_seq',  minvalue=0, schema='pl_livedb')))

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('LiveDbModelSet',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('comment', sa.String(), nullable=True),
    sa.Column('propsJson', sa.String(length=500), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_livedb'
    )
    op.create_table('Setting',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_livedb'
    )



    op.create_table('LiveDbItem',
    sa.Column('id', sa.Integer(), server_default=nextval("LiveDbItem_id_seq"), nullable=False),
    sa.Column('modelSetId', sa.Integer(), nullable=False),
    sa.Column('key', sa.String(length=50), nullable=False),
    sa.Column('rawValue', sa.String(length=255), nullable=True),
    sa.Column('displayValue', sa.String(length=255), nullable=True),
    sa.Column('dataType', sa.Integer(), nullable=False),
    sa.Column('importHash', sa.String(length=100), nullable=True),
    sa.Column('propsJson', sa.String(length=500), nullable=True),
    sa.ForeignKeyConstraint(['modelSetId'], ['pl_livedb.LiveDbModelSet.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_livedb'
    )
    op.create_index('idx_LiveDbDKey_importHash', 'LiveDbItem', ['importHash'], unique=False, schema='pl_livedb')
    op.create_index('idx_LiveDbDKey_liveDbKey', 'LiveDbItem', ['key'], unique=False, schema='pl_livedb')
    op.create_index('idx_LiveDbDKey_modelSetId', 'LiveDbItem', ['modelSetId'], unique=False, schema='pl_livedb')
    op.create_table('SettingProperty',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('settingId', sa.Integer(), nullable=False),
    sa.Column('key', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=True),
    sa.Column('int_value', sa.Integer(), nullable=True),
    sa.Column('char_value', sa.String(length=50), nullable=True),
    sa.Column('boolean_value', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['settingId'], ['pl_livedb.Setting.id'], ),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_livedb'
    )
    op.create_index('idx_SettingProperty_settingId', 'SettingProperty', ['settingId'], unique=False, schema='pl_livedb')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_SettingProperty_settingId', table_name='SettingProperty', schema='pl_livedb')
    op.drop_table('SettingProperty', schema='pl_livedb')
    op.drop_index('idx_LiveDbDKey_modelSetId', table_name='LiveDbItem', schema='pl_livedb')
    op.drop_index('idx_LiveDbDKey_liveDbKey', table_name='LiveDbItem', schema='pl_livedb')
    op.drop_index('idx_LiveDbDKey_importHash', table_name='LiveDbItem', schema='pl_livedb')
    op.drop_table('LiveDbItem', schema='pl_livedb')
    op.drop_table('Setting', schema='pl_livedb')
    op.drop_table('LiveDbModelSet', schema='pl_livedb')
    # ### end Alembic commands ###