/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.filter.common;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.filter.common.ListIdTracker;
import org.openstreetmap.osmosis.core.util.LongAsInt;

public class BitSetIdTracker
implements IdTracker {
    BitSet positiveSet = new BitSet();
    ListIdTracker negativeSet = new ListIdTracker();

    @Override
    public void set(long id) {
        int intId = LongAsInt.longToInt(id);
        if (intId >= 0) {
            this.positiveSet.set(intId);
        } else {
            this.negativeSet.set(intId);
        }
    }

    @Override
    public boolean get(long id) {
        int intId = LongAsInt.longToInt(id);
        boolean result = intId >= 0 ? this.positiveSet.get(intId) : this.negativeSet.get(intId);
        return result;
    }

    @Override
    public Iterator<Long> iterator() {
        return new IdIterator();
    }

    @Override
    public void setAll(IdTracker idTracker) {
        for (Long id : idTracker) {
            this.set(id);
        }
    }

    private class IdIterator
    implements Iterator<Long> {
        private boolean readingPositive = false;
        private long nextId;
        private boolean nextIdAvailable = false;
        private Iterator<Long> negativeIterator;
        private int positiveOffset = 0;

        IdIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.nextIdAvailable) {
                int nextBitOffset;
                if (!this.readingPositive) {
                    if (this.negativeIterator == null) {
                        this.negativeIterator = BitSetIdTracker.this.negativeSet.iterator();
                    }
                    if (this.negativeIterator.hasNext()) {
                        this.nextId = this.negativeIterator.next();
                        this.nextIdAvailable = true;
                    } else {
                        this.negativeIterator = null;
                        this.readingPositive = true;
                    }
                }
                if (this.readingPositive && (nextBitOffset = BitSetIdTracker.this.positiveSet.nextSetBit(this.positiveOffset)) >= 0) {
                    this.nextId = nextBitOffset;
                    this.nextIdAvailable = true;
                    this.positiveOffset = nextBitOffset + 1;
                }
            }
            return this.nextIdAvailable;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextIdAvailable = false;
            return this.nextId;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

