/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class MultipleSourceIterator<T>
implements ReleasableIterator<T> {
    private List<ReleasableIterator<T>> sources;

    public MultipleSourceIterator(List<ReleasableIterator<T>> sources) {
        this.sources = new LinkedList<ReleasableIterator<T>>(sources);
    }

    @Override
    public boolean hasNext() {
        while (this.sources.size() > 0) {
            if (this.sources.get(0).hasNext()) {
                return true;
            }
            this.sources.remove(0).close();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)this.sources.get(0).next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (ReleasableIterator<T> source : this.sources) {
            source.close();
        }
    }
}

