#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['facet',
 'facet.crossfit',
 'facet.data',
 'facet.data.partition',
 'facet.inspection',
 'facet.selection',
 'facet.simulation',
 'facet.simulation.viz',
 'facet.validation']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['gamma-pytools  ~=1.2,>=1.2.1',
 'matplotlib     ~=3.0',
 'numpy          >=1.17,<2a',
 'packaging      >=20',
 'pandas         >=0.24,<2a',
 'scipy          ~=1.2',
 'shap           >=0.34,<0.40a',
 'sklearndf      ~=1.2',
 'ipython        >=7']

extras_require = \
{'docs': ['sphinx ~= 3.4.0',
          'sphinx-autodoc-typehints ~= 1.11.0',
          'pydata-sphinx-theme ~= 0.4.0',
          'jinja2 ~= 2.11',
          'nbsphinx ~= 0.8.5',
          'jupyter ~= 1.0',
          'docutils ~= 0.16.0',
          'xlrd ~= 1.2',
          'm2r ~= 0.2.0'],
 'testing': ['pytest ~= 5.2',
             'pytest-cov ~= 2.8',
             'flake8 ~= 3.8',
             'flake8-comprehensions ~= 3.2',
             'isort ~= 5.5']}

setup(name='gamma-facet',
      version='1.2.0',
      description='Human-explainable AI.',
      author='Boston Consulting Group (BCG)',
      author_email=None,
      url='https://github.com/BCG-Gamma/facet',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6,<4a',
     )
