# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flask_strip_whitespace', 'flask_strip_whitespace.middlewares']

package_data = \
{'': ['*']}

install_requires = \
['flask>=2.2.2,<3.0.0', 'python-strip-whitespace>=0.1.0,<0.2.0']

setup_kwargs = {
    'name': 'flask-strip-whitespace',
    'version': '0.1.0',
    'description': 'A powerful HTML whitespace remover for Flask',
    'long_description': 'HTML Whitespace remover for Flask\n==================================\n|Pepy.tech Badge| |PyPi Version Badge| |Python Versions Badge| |License Badge| |Code Style|\n\n.. |Pepy.tech Badge| image:: https://static.pepy.tech/personalized-badge/flask-strip-whitespace?period=week&units=international_system&left_color=grey&right_color=orange&left_text=Downloads\n   :target: https://pepy.tech/project/flask-strip-whitespace\n\n.. |PyPi Version Badge| image:: https://badge.fury.io/py/flask-strip-whitespace.svg\n    :target: https://badge.fury.io/py/flask-strip-whitespace\n\n.. |Python Versions Badge| image:: https://img.shields.io/pypi/pyversions/flask-strip-whitespace\n    :alt: PyPI - Python Version\n    :target: https://github.com/baseplate-admin/flask_strip_whitespace/blob/main/setup.py\n\n.. |License Badge| image:: https://img.shields.io/pypi/l/flask-strip-whitespace\n   :alt: PyPI - License\n   :target: https://github.com/baseplate-admin/flask_strip_whitespace/blob/main/LICENSE\n   \n.. |Code Style| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :alt: Code Style\n   \nIntroduction :\n--------------\nA powerful tool to optimize Flask rendered templates\n\nWhy use "flask_stip_whitespace" ?\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n*   Adds line break to InlineJS.\n*   It can automagically minify inline CSS, JS.\n*   Removes <!--prettier-ignore--> from HTML.\n*   It speeds up website by reducing the HTML size.\n*   It compiles regex at runtime. So it\'s blazing fast.\n*   Its mostly based on C ( gzip ) and Rust ( `minify-html <https://pypi.org/project/minify-html/>`__  ) libraries.\n*   Significantly lower bytes transferred when working with frameworks like AlpineJs ( Almost fully working & Please open a issue in the `Issue Tracker <https://github.com/baseplate-admin/flask_strip_whitespace/issues>`__ if you encounter any bug) & Petite Vue.\n*   Is very customizable. ( You can configure lower level `minify-html <https://github.com/wilsonzlin/minify-html/blob/master/python/src/lib.template.rs/>`_ rust bindings and also the lower level `python <https://github.com/juancarlospaco/css-html-js-minify/blob/master/css_html_js_minify/html_minifier.py/>`_ bindings from flask\'s configuration )\n\n\nWhy shouldn\'t you use "flask_stip_whitespace" ?\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n*   You don\'t like having unnecessary \';;\' in your HTML. ( If you know any regex to fix this please put a pull request )\n\n*   Although I tried my best to use Compiled Language for Optimizations. It can still be sub miliseconds ( > 0.001 ) slower compared to normal Flask Rendering. ( If you know any way to improve performance, please put a pull request )\n\n\nRequirements :\n--------------\n\n*    `python-strip-whitespace <https://github.com/baseplate-admin/python_strip_whitespace>`_\n*    Flask\n*    Python 3 ( Should work with all version? )\n*    Brotli ( or BrotliPy; pypy ) | ( Optional )\n*    ZSTD ( Optional ) \n\nUser guide :\n============\n\nInstallation :\n--------------\n\nInstall with pip from pypi (No extra dependencies)::\n\n      $ python -m pip install flask_strip_whitespace\n\nInstall with pip with Brotli support::\n\n      $ python -m pip install flask_strip_whitespace[brotli]\n\nSame but with Zstandard support::\n\n      $ python -m pip install flask_strip_whitespace[zstd]\n\n\n\n\nInstall with pip from github ( Development | Not Recommended for Production )::\n    \n      $ python -m pip install https://codeload.github.com/baseplate-admin/flask_strip_whitespace/zip/refs/heads/main\n\n\nThen include it in your flask project:\n   \n.. code-block:: python\n\n     from flask_strip_whitespace.middlewares import HTMLStripWhiteSpaceMiddleware\n\n     # Declare a dictionary to store config. \n     # Note that this dictionary must be called before adding wsgi middleware.\n     STRIP_WHITESPACE_CONFIG : dict = {}\n\n     app = Flask(__name__)\n     app.wsgi_app = HTMLStripWhiteSpaceMiddleware(app.wsgi_app, config=STRIP_WHITESPACE_CONFIG) # Note that config is a python dictionary \n\nCustomization :\n===============\n\nChange Lower Level Bindings :\n-----------------------------\n\nRust :\n~~~~~~\n\nThe module allows `rust <https://github.com/wilsonzlin/minify-html>`_ minifier options to be changed from Flask\'s environ variables. If you would like to change any settings, refer to `minify-html\'s <https://github.com/wilsonzlin/minify-html/blob/master/python/src/lib.template.rs/>`_ source code.\n\n\nThe bindings are ( by default set to True ):\n\n.. code-block:: python\n\n      STRIP_WHITESPACE_RUST_DO_NOT_MINIFY_DOCTYPE, # passes do_not_minify_doctype to minify-html\n      STRIP_WHITESPACE_RUST_ENSURE_SPEC_CONPLIANT_UNQUOTED_ATTRIBUTE_VALUES, # passes ensure_spec_compliant_unquoted_attribute_values to minify-html\n      STRIP_WHITESPACE_RUST_KEEP_CLOSING_TAGS, # passes keep_closing_tags to minify-html\n      STRIP_WHITESPACE_RUST_KEEP_COMMENTS, # passes keep_comments to minify-html\n      STRIP_WHITESPACE_RUST_KEEP_HTML_AND_HEAD_OPENING_TAGS, # passes keep_html_and_head_opening_tags to minify-html\n      STRIP_WHITESPACE_RUST_KEEP_SPACES_BETWEEN_ATTRIBUTES, # passes keep_spaces_between_attributes to minify-html\n      STRIP_WHITESPACE_RUST_MINIFY_CSS, # passes minify_css to minify-html\n      STRIP_WHITESPACE_RUST_MINIFY_JS, # passes minify_js to minify-html\n      STRIP_WHITESPACE_RUST_REMOVE_BANGS, # passes remove_bangs to minify-html\n      STRIP_WHITESPACE_RUST_REMOVE_PROCESSING_INSTRUCTIONS, # passes remove_processing_instructions to minify-html\n\nIf you would like to change any of the above variables, simply put them in STRIP_WHITESPACE_CONFIG ( Please note that every variable here is a python boolean ).\n\nFor example:\n\n.. code-block:: python\n         \n        STRIP_WHITESPACE_CONFIG[\'STRIP_WHITESPACE_RUST_DO_NOT_MINIFY_DOCTYPE\'] = False\n\nPython :\n~~~~~~~~\n\nThe module allows python minifier options to be changed from Flasks\'s environ variables. If you would like to change any settings, refer to `python-module\'s <https://github.com/juancarlospaco/css-html-js-minify/blob/master/css_html_js_minify/html_minifier.py/>`_ source code.\n\nThe bindings are ( by default set to a sane value ):\n\n.. code-block:: python\n\n        STRIP_WHITESPACE_PYTHON_REMOVE_COMMENTS, # False | removes comments from HTML using python ( not recommended cause rust can do that just fine and fast )\n        STRIP_WHITESPACE_PYTHON_CONDENSE_STYLE_FROM_HTML, # True | replaces \'<style text/css>\' -> \'<style>\'\n        STRIP_WHITESPACE_PYTHON_CONDENSE_SCRIPT_FROM_HTML, # True | replaces \'<script text/javascript>\' -> \'<script>\'\n        STRIP_WHITESPACE_PYTHON_CLEAN_UNNEEDED_HTML_TAGS, # True | removes some unnecessary tags\n        STRIP_WHITESPACE_PYTHON_CONDENSE_HTML_WHITESPACE, # True | This is where the magic happens.\n        STRIP_WHITESPACE_PYTHON_UNQUOTE_HTML_ATTRIBUTES, # True | This is also a magic module.\n       \n\nIf you would like to change any of the above variables, simply put them in STRIP_WHITESPACE_CONFIG ( Please note that every variable here is a python boolean )\n\nFor example:\n\n.. code-block:: python\n\n        STRIP_WHITESPACE_CONFIG[\'STRIP_WHITESPACE_PYTHON_REMOVE_COMMENTS\'] = True\n\nChange Ignored Paths :\n----------------------\n\nThis module allows dynamic ignored path allocation.\nSo for example if your sitemap.xml is at url \'/sitemap.xml\' and you want to avoid minifying it ( Because this module in lower level is meant to minify HTML not XML ).\nThen you can add it to ignored path. ( By default it ignores \'/sitemap.xml\' ) \n\nTo customize ignored path:\n\n.. code-block:: python\n        \n\n        STRIP_WHITESPACE_CONFIG[\'STRIP_WHITESPACE_MINIFY_IGNORED_PATHS\'].append("/robots.txt") # Note that STRIP_WHITESPACE_MINIFY_IGNORED_PATHS is a Python List\n\nChange NBSP Mangle Character :\n------------------------------\n\nThis module first replaces the &nbsp; character from html with a character. \nFor example &nbsp; becomes \'অ\' ( I picked \'অ\' because its a foreign character and not many sites use the character like this \'অ\' ).\nIf for some reason this character is causing problem in your HTML. You can change this from STRIP_WHITESPACE_CONFIG .\n\nTo change &nbsp; mangle character:\n\n.. code-block:: python\n\n\n        # Keep the string as  short as possible.\n        # If you make it long,\n        # the python str.replace() method will use more CPU and RAM thus slowing your site down.\n        \n        STRIP_WHITESPACE_CONFIG["STRIP_WHITESPACE_NBSP_MANGLE_CHARACTER"] = \'ga\' # Note that STRIP_WHITESPACE_NBSP_MANGLE_CHARACTER is a python string\n\nChange Compression Settings :\n-----------------------------\nThis module can do the work of compressing response to gzip. ( It can also do brotli, zstd 👀 )\n\nTo change the compression algorithm ( by default using \'gzip\' because it\'s a python stdlib): \n   \n.. code-block:: python\n      \n      # envrion\n\n      STRIP_WHITESPACE_CONFIG["STRIP_WHITESPACE_COMPRESSION_ALGORITHM"] = "gzip" or "br" or "zstd" or "plain"\n      \n\nContributing :\n==============\nIf you like this project add a star. \nIf you have problems or suggestions please put them in the `Issue Tracker <https://github.com/baseplate-admin/flask_strip_whitespace/issues>`__.\nIf you like to add features. Fork this repo and submit a Pull Request. 😛\n\nUpdates ?? :\n============\nThis repository is freezed. It will automatically install latest `python-strip-whitespace <https://github.com/baseplate-admin/python_strip_whitespace>`_\n\n',
    'author': 'baseplate-admin',
    'author_email': '61817579+baseplate-admin@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
