# Generated by Django 2.2.15 on 2020-09-01 02:34

from django.db import migrations, models
import django.db.models.deletion
import django_safe_fields.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SmtpServer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('code', models.CharField(max_length=64, unique=True, verbose_name='Code')),
                ('is_failback_server', models.BooleanField(default=False, verbose_name='Failback Server')),
                ('order', models.IntegerField(default=1000, verbose_name='Order')),
                ('enable', models.BooleanField(verbose_name='Enable')),
                ('enable_time', models.DateTimeField(blank=True, null=True, verbose_name='Enabled Time')),
                ('disable_time', models.DateTimeField(blank=True, null=True, verbose_name='Disabled Time')),
                ('add_time', models.DateTimeField(auto_now_add=True, verbose_name='Add Time')),
                ('mod_time', models.DateTimeField(auto_now=True, verbose_name='Modify Time')),
                ('sender', django_safe_fields.fields.SafeCharField(blank=True, max_length=256, null=True, verbose_name='Sender')),
                ('options_raw', django_safe_fields.fields.SafeTextField(blank=True, null=True, verbose_name='Smtp Server Options')),
            ],
            options={
                'verbose_name': 'Smtp Server',
                'verbose_name_plural': 'Smtp Servers',
            },
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('code', models.CharField(max_length=64, unique=True, verbose_name='Code')),
                ('enable', models.BooleanField(verbose_name='Enable')),
                ('enable_time', models.DateTimeField(blank=True, null=True, verbose_name='Enabled Time')),
                ('disable_time', models.DateTimeField(blank=True, null=True, verbose_name='Disabled Time')),
                ('add_time', models.DateTimeField(auto_now_add=True, verbose_name='Add Time')),
                ('mod_time', models.DateTimeField(auto_now=True, verbose_name='Modify Time')),
                ('subject', models.CharField(blank=True, max_length=256, null=True, verbose_name='Subject')),
                ('body', models.TextField(blank=True, null=True, verbose_name='Body')),
            ],
            options={
                'verbose_name': 'Mail Template',
                'verbose_name_plural': 'Mail Templates',
            },
        ),
        migrations.CreateModel(
            name='MailForDelivery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_time', models.DateTimeField(auto_now_add=True, verbose_name='Add Time')),
                ('mod_time', models.DateTimeField(auto_now=True, verbose_name='Modify Time')),
                ('status', models.IntegerField(blank=True, choices=[(10, 'Task Ready'), (20, 'Task Doing'), (30, 'Task Done'), (40, 'Task Failed')], null=True, verbose_name='Status')),
                ('worker', models.CharField(blank=True, max_length=128, null=True, verbose_name='Worker Name')),
                ('start_time', models.DateTimeField(blank=True, null=True, verbose_name='Start Time')),
                ('done_time', models.DateTimeField(blank=True, null=True, verbose_name='Done Time')),
                ('error_time', models.DateTimeField(blank=True, null=True, verbose_name='Error Time')),
                ('result', models.TextField(blank=True, null=True, verbose_name='Result')),
                ('error_code', models.IntegerField(blank=True, null=True, verbose_name='Error Code')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='Error Message')),
                ('subject', models.CharField(max_length=512, verbose_name='Subject')),
                ('body', models.TextField(blank=True, null=True, verbose_name='Body')),
                ('variables_raw', models.TextField(blank=True, null=True, verbose_name='Variables')),
                ('sender', django_safe_fields.fields.SafeCharField(blank=True, max_length=1024, null=True, verbose_name='Sender')),
                ('recipient', django_safe_fields.fields.SafeCharField(max_length=1024, verbose_name='Recipient')),
                ('server', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_mailcenter.SmtpServer', verbose_name='Smtp Server')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_mailcenter.Template', verbose_name='Mail Template')),
            ],
            options={
                'verbose_name': 'Mail For Delivery',
                'verbose_name_plural': 'Mails ForDelivery',
            },
        ),
        migrations.CreateModel(
            name='AttachmentOfMailForDelivery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to='django-mailcenter/MailForDelivery/Attachments/', verbose_name='File')),
                ('filename', models.CharField(blank=True, max_length=256, null=True, verbose_name='Filename')),
                ('mail', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='django_mailcenter.MailForDelivery', verbose_name='Mail')),
            ],
            options={
                'verbose_name': 'Attachment Of Mail For Delivery',
                'verbose_name_plural': 'Attachments Of Mail For Delivery',
            },
        ),
    ]
