import * as lambda from '@aws-cdk/aws-lambda';
import * as ses from '@aws-cdk/aws-ses';
import * as sns from '@aws-cdk/aws-sns';
/**
 * The type of invocation to use for a Lambda Action.
 *
 * @stability stable
 */
export declare enum LambdaInvocationType {
    /**
     * The function will be invoked asynchronously.
     *
     * @stability stable
     */
    EVENT = "Event",
    /**
     * The function will be invoked sychronously.
     *
     * Use RequestResponse only when
     * you want to make a mail flow decision, such as whether to stop the receipt
     * rule or the receipt rule set.
     *
     * @stability stable
     */
    REQUEST_RESPONSE = "RequestResponse"
}
/**
 * Construction properties for a Lambda action.
 *
 * @stability stable
 */
export interface LambdaProps {
    /**
     * The Lambda function to invoke.
     *
     * @stability stable
     */
    readonly function: lambda.IFunction;
    /**
     * The invocation type of the Lambda function.
     *
     * @default Event
     * @stability stable
     */
    readonly invocationType?: LambdaInvocationType;
    /**
     * The SNS topic to notify when the Lambda action is taken.
     *
     * @default no notification
     * @stability stable
     */
    readonly topic?: sns.ITopic;
}
/**
 * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
 *
 * @stability stable
 */
export declare class Lambda implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: LambdaProps);
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
