"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_LambdaRestApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaRestApi);
            }
            throw error;
        }
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
_a = JSII_RTTI_SYMBOL_1;
LambdaRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.LambdaRestApi", version: "1.169.0" };
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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