# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-08-09 18:28
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0011_auto_20170720_1945'),
    ]

    operations = [
        migrations.CreateModel(
            name='SeriesCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Category name will be displayed.', max_length=100, unique=True, verbose_name='Name')),
                ('description', models.TextField(blank=True, help_text='Add an optional description.', null=True, verbose_name='Description')),
                ('slug', models.SlugField(help_text='This slug is used primarily for custom templates in registration, if the category is shown separately on the registration page.  You can override the default.', verbose_name='Slug')),
                ('separateOnRegistrationPage', models.BooleanField(default=False, verbose_name='Show category separately on registration page')),
            ],
            options={
                'verbose_name_plural': 'Series categories',
                'verbose_name': 'Series category',
            },
        ),
        migrations.AlterModelOptions(
            name='pricingtier',
            options={'verbose_name': 'Pricing tier', 'verbose_name_plural': 'Pricing tiers'},
        ),
        migrations.RemoveField(
            model_name='series',
            name='special',
        ),
        migrations.AddField(
            model_name='publiceventcategory',
            name='separateOnRegistrationPage',
            field=models.BooleanField(default=False, verbose_name='Show category separately on registration page'),
        ),
        migrations.AddField(
            model_name='publiceventcategory',
            name='slug',
            field=models.SlugField(default='slug', help_text='This slug is used primarily for custom templates in registration, if the category is shown separately on the registration page.  You can override the default.', verbose_name='Slug'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='series',
            name='allowDropins',
            field=models.BooleanField(default=False, help_text='If checked, then all staff will be able to register students as drop-ins.', verbose_name='Allow class drop-ins'),
        ),
        migrations.AddField(
            model_name='series',
            name='category',
            field=models.ForeignKey(blank=True, help_text='Custom series categories may be used to display special series (e.g. one-offs, visiting instructors) separately on your registration page.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.SeriesCategory', verbose_name='Series category (optional)'),
        ),
        migrations.AlterField(
            model_name='publicevent',
            name='category',
            field=models.ForeignKey(blank=True, help_text='Custom event categories may be used to display special types of events (e.g. practice sessions) separately on your registration page.  They may also be displayed in different colors on the public calendar.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PublicEventCategory', verbose_name='Category (optional)'),
        ),
    ]
