# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-08-10 20:34
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0020_auto_20180808_2247'),
    ]

    operations = [
        migrations.CreateModel(
            name='EventSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Session name will be displayed.', max_length=100, verbose_name='Name')),
                ('description', models.TextField(blank=True, help_text='Add an optional description.', null=True, verbose_name='Description')),
                ('slug', models.SlugField(help_text='Events can be accessed by a URL based on this slug, as well as by a URL specified by month.', verbose_name='Slug')),
                ('startTime', models.DateTimeField(blank=True, help_text='This value should be populated automatically based on the first start time of any event associated with this session.', null=True, verbose_name='Start Time')),
                ('endTime', models.DateTimeField(blank=True, help_text='This value should be populated automatically based on the last end time of any event associated with this session.', null=True, verbose_name='End Time')),
            ],
            options={
                'verbose_name': 'Event session',
                'verbose_name_plural': 'Event sessions',
                'ordering': ('startTime', 'name'),
            },
        ),
        migrations.AddField(
            model_name='event',
            name='session',
            field=models.ForeignKey(blank=True, help_text='Optional event sessions can be used to order events for registration.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.EventSession', verbose_name='Session'),
        ),
    ]
