# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-17 16:42
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('discounts', '0001_initial'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='discountcombo',
            options={'verbose_name': 'Discount', 'verbose_name_plural': 'Discounts'},
        ),
        migrations.AlterModelOptions(
            name='discountcombocomponent',
            options={'verbose_name': 'Required component of discount', 'verbose_name_plural': 'Required components of discount'},
        ),
        migrations.AlterModelOptions(
            name='pointgroup',
            options={'verbose_name': 'Point group type', 'verbose_name_plural': 'Point group types'},
        ),
        migrations.AlterModelOptions(
            name='pricingtiergroup',
            options={'verbose_name': 'Pricing tier point group', 'verbose_name_plural': 'Pricing tier point groups'},
        ),
        migrations.AlterModelOptions(
            name='registrationdiscount',
            options={'verbose_name': 'Discount applied to registration', 'verbose_name_plural': 'Discounts applied to registrations'},
        ),
        migrations.AlterModelOptions(
            name='temporaryregistrationdiscount',
            options={'verbose_name': 'Discount applied to temporary registration', 'verbose_name_plural': 'Discounts applied to temporary registrations'},
        ),
        migrations.AlterField(
            model_name='discountcombo',
            name='active',
            field=models.BooleanField(default=True, help_text="Uncheck this to 'turn off' this discount", verbose_name='Active'),
        ),
        migrations.AlterField(
            model_name='discountcombo',
            name='discountType',
            field=models.CharField(choices=[('F', 'Exact Specified Price'), ('D', 'Dollar Discount from Regular Price'), ('P', 'Percentage Discount from Regular Price'), ('A', 'Free Add-on Item (Can be combined with other discounts)')], help_text="Is this a flat price, a dollar amount discount, a 'percentage off' discount, or a free add-on?", max_length=1, verbose_name='Discount type'),
        ),
        migrations.AlterField(
            model_name='discountcombo',
            name='dollarDiscount',
            field=models.FloatField(blank=True, help_text="This amount will be subtracted from the customer's total (in currency units, e.g. dollars).", null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Amount of dollar discount'),
        ),
        migrations.AlterField(
            model_name='discountcombo',
            name='name',
            field=models.CharField(help_text="Give this discount combination a name (e.g. 'Two 4-week series')", max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='discountcombo',
            name='percentDiscount',
            field=models.FloatField(blank=True, help_text="This percentage will be subtracted from the customer's total.", null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Amount of percentage discount'),
        ),
        migrations.AlterField(
            model_name='discountcombo',
            name='percentUniversallyApplied',
            field=models.BooleanField(default=False, help_text='If checked, then the percentage discount will be applied to all items in the order, not just the items that qualify the order for this discount combination (e.g. 20% off all registrations of three or more classes.', verbose_name='Percentage discount is univerally applied'),
        ),
        migrations.AlterField(
            model_name='discountcombocomponent',
            name='discountCombo',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.DiscountCombo', verbose_name='Discount'),
        ),
        migrations.AlterField(
            model_name='discountcombocomponent',
            name='level',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceTypeLevel', verbose_name='Dance type/level'),
        ),
        migrations.AlterField(
            model_name='discountcombocomponent',
            name='quantity',
            field=models.PositiveSmallIntegerField(default=1, verbose_name='Quantity'),
        ),
        migrations.AlterField(
            model_name='discountcombocomponent',
            name='weekday',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(None, ''), (0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], help_text='Leave this blank for no restriction on days of the week', null=True, verbose_name='Weekday'),
        ),
        migrations.AlterField(
            model_name='pointgroup',
            name='name',
            field=models.CharField(help_text="Give this pricing tier point group a name (e.g. 'Regular Series Class Hours')", max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='pricingtiergroup',
            name='group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.PointGroup', verbose_name='Point group'),
        ),
        migrations.AlterField(
            model_name='pricingtiergroup',
            name='points',
            field=models.PositiveIntegerField(default=0, verbose_name='# of Points'),
        ),
        migrations.AlterField(
            model_name='pricingtiergroup',
            name='pricingTier',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier', verbose_name='Pricing tier'),
        ),
        migrations.AlterField(
            model_name='registrationdiscount',
            name='discount',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.DiscountCombo', verbose_name='Discount'),
        ),
        migrations.AlterField(
            model_name='registrationdiscount',
            name='registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.Registration', verbose_name='Registration'),
        ),
        migrations.AlterField(
            model_name='temporaryregistrationdiscount',
            name='discount',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.DiscountCombo', verbose_name='Discount'),
        ),
        migrations.AlterField(
            model_name='temporaryregistrationdiscount',
            name='registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration', verbose_name='Temporary registration'),
        ),
    ]
