# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-17 16:42
from __future__ import unicode_literals

import datetime
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('financial', '0003_auto_20170614_1607'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='expensecategory',
            options={'verbose_name': 'Expense category', 'verbose_name_plural': 'Expense categories'},
        ),
        migrations.AlterModelOptions(
            name='expenseitem',
            options={'ordering': ['-accrualDate'], 'permissions': (('mark_expenses_paid', 'Mark expenses as paid at the time of submission'),), 'verbose_name': 'Expense item', 'verbose_name_plural': 'Expense items'},
        ),
        migrations.AlterModelOptions(
            name='revenuecategory',
            options={'verbose_name': 'Revenue category', 'verbose_name_plural': 'Revenue categories'},
        ),
        migrations.AlterModelOptions(
            name='revenueitem',
            options={'ordering': ['-accrualDate'], 'permissions': (('export_financial_data', 'Export detailed financial transaction information to CSV'), ('view_finances_bymonth', 'View school finances month-by-month'), ('view_finances_byevent', 'View school finances by Event'), ('view_finances_detail', 'View school finances as detailed statement')), 'verbose_name': 'Revenue item', 'verbose_name_plural': 'Revenue items'},
        ),
        migrations.AlterField(
            model_name='expensecategory',
            name='defaultRate',
            field=models.FloatField(blank=True, help_text='This is the default hourly payment rate for this type of task.  For staff expenses and venue rentals, this will be overridden by the rate specified as default for the venue or staff type.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Default rate'),
        ),
        migrations.AlterField(
            model_name='expensecategory',
            name='name',
            field=models.CharField(help_text='Different types of tasks and payments should have different category names', max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='accrualDate',
            field=models.DateTimeField(verbose_name='Accrual date'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='adjustments',
            field=models.FloatField(default=0, help_text='Record any ex-post adjustments to the amount (e.g. refunds) in this field. A positive amount increases the netExpense, a negative amount reduces the netExpense.', verbose_name='Adjustments/refunds'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='approvalDate',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Approval date'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='approved',
            field=models.BooleanField(default=False, help_text='Check to indicate that expense is approved for payment.', verbose_name='Approved'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='financial.ExpenseCategory', verbose_name='Category'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='description',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='event',
            field=models.ForeignKey(blank=True, help_text='If this item is associated with an Event, enter it here.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Event', verbose_name='Event'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='eventstaffmember',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.EventStaffMember', verbose_name='Staff member'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='eventvenue',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='venueexpense', to='core.Event', verbose_name='Event venue'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='fees',
            field=models.FloatField(default=0, help_text='The sum of any transaction fees (e.g. Paypal fees) that were paid <strong>by us</strong>, and should therefore be added to net expense.', verbose_name='Fees'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='hours',
            field=models.FloatField(blank=True, help_text='Please indicate the number of hours to be paid for.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Hours'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='paid',
            field=models.BooleanField(default=False, help_text='Check to indicate that payment has been made.', verbose_name='Paid'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='payToLocation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Location', verbose_name='Pay to location'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='payToName',
            field=models.CharField(blank=True, max_length=50, null=True, verbose_name='Pay to (enter name)'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='payToUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='payToUser', to=settings.AUTH_USER_MODEL, verbose_name='Pay to user'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='paymentDate',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Payment date'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='reimbursement',
            field=models.BooleanField(default=False, help_text='Check to indicate that this is a reimbursement expense (i.e. not compensation).', verbose_name='Reimbursement'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='submissionDate',
            field=models.DateTimeField(default=datetime.datetime.now, verbose_name='Submission date'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='expensessubmittedby', to=settings.AUTH_USER_MODEL, verbose_name='Submission user'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='total',
            field=models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Total amount'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='wageRate',
            field=models.FloatField(blank=True, help_text='This should be filled automatically, but can be changed as needed.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Wage rate'),
        ),
        migrations.AlterField(
            model_name='revenuecategory',
            name='defaultAmount',
            field=models.FloatField(blank=True, help_text='This is the default amount of revenue for items in this category.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Default amount'),
        ),
        migrations.AlterField(
            model_name='revenuecategory',
            name='name',
            field=models.CharField(help_text='Different types of revenue fall under different categories.', max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='accrualDate',
            field=models.DateTimeField(verbose_name='Accrual date'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='financial.RevenueCategory', verbose_name='Category'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='description',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='event',
            field=models.ForeignKey(blank=True, help_text='If this item is associated with an Event, enter it here.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Event', verbose_name='Event'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='invoiceItem',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.InvoiceItem', verbose_name='Associated invoice item'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='received',
            field=models.BooleanField(default=False, help_text='Check to indicate that payment has been received. Non-received payments are considered pending.', verbose_name='Received'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='receivedDate',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Date received'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='submissionDate',
            field=models.DateTimeField(default=datetime.datetime.now, verbose_name='Submission date'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='revenuessubmittedby', to=settings.AUTH_USER_MODEL, verbose_name='Submission user'),
        ),
    ]
