# Generated by Django 2.2.6 on 2020-01-06 00:33

import cms.models.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0022_auto_20180620_1551'),
        ('core', '0028_merge_20190822_2304'),
    ]

    operations = [
        migrations.CreateModel(
            name='DoorRegisterPaymentMethod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Method name')),
                ('requireFullRegistration', models.CharField(choices=[('A', 'Always required'), ('O', 'Only if required by the plugin')], max_length=1, verbose_name='Is full registration (name and email) required?')),
            ],
            options={
                'verbose_name': 'Payment method',
                'verbose_name_plural': 'Payment methods',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='DoorRegisterEventPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='door_doorregistereventpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(blank=True, default='Upcoming Events', max_length=250, verbose_name='Custom list title')),
                ('eventType', models.CharField(choices=[('B', 'Class Series and Public Events'), ('S', 'Only Class Series'), ('P', 'Only Public Events')], default='B', max_length=1, verbose_name='Limit to event type')),
                ('limitNumber', models.PositiveSmallIntegerField(blank=True, help_text='Leave blank for no restriction', null=True, verbose_name='Limit number')),
                ('sortOrder', models.CharField(choices=[('A', 'Ascending'), ('D', 'Descending')], default='A', help_text='This may be overridden by the particular template in use', max_length=1, verbose_name='Sort by start time')),
                ('occursWithinDays', models.PositiveSmallIntegerField(blank=True, default=0, help_text='If set, then the register will only include events that have an occurrence within this many days in the future of the register date(usually) the current date. The default of 0 limits to only events that occur on the register date. Leave blank for no restriction.', null=True, verbose_name='Limit number')),
                ('limitTypeStart', models.CharField(choices=[('S', 'Event start date'), ('E', 'Event end date')], default='E', max_length=1, verbose_name='Limit interval start by')),
                ('daysStart', models.SmallIntegerField(blank=True, help_text='(E.g. enter -30 for an interval that starts with 30 days prior to today) Leave blank for no limit, or enter 0 to limit to future events', null=True, verbose_name='Interval limited to __ days from present')),
                ('startDate', models.DateField(blank=True, help_text='Leave blank for no limit (overrides relative interval limits)', null=True, verbose_name='Exact interval start date')),
                ('limitTypeEnd', models.CharField(choices=[('S', 'Event start date'), ('E', 'Event end date')], default='S', max_length=1, verbose_name='Limit interval end by')),
                ('daysEnd', models.SmallIntegerField(blank=True, help_text='(E.g. enter 30 for an interval that ends 30 days from today) Leave blank for no limit, or enter 0 to limit to past events', null=True, verbose_name='Interval limited to __ days from present')),
                ('endDate', models.DateField(blank=True, help_text='Leave blank for no limit (overrides relative interval limits)', null=True, verbose_name='Exact interval end date ')),
                ('registrationOpenLimit', models.CharField(choices=[('O', 'Open for registration only'), ('C', 'Closed for registration only'), ('B', 'Both open and closed events')], default='O', max_length=1, verbose_name='Limit to open/closed for registration only')),
                ('weekday', models.PositiveSmallIntegerField(blank=True, choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], null=True, verbose_name='Limit to weekday')),
                ('cssClasses', models.CharField(blank=True, help_text='Classes are applied to surrounding &lt;div&gt;', max_length=250, null=True, verbose_name='Custom CSS classes')),
                ('template', models.CharField(blank=True, max_length=250, null=True, verbose_name='Plugin template')),
                ('requireFullRegistration', models.BooleanField(blank=True, default=True, help_text='If checked, then the user will be sent to the second page of the registration process to provide name and email. Particular payment methods may also require the full registration process.', verbose_name='Require full registration')),
                ('eventCategories', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.PublicEventCategory', verbose_name='Limit to public event categories')),
                ('levels', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.DanceTypeLevel', verbose_name='Limit to type and levels')),
                ('location', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.Location', verbose_name='Limit to locations')),
                ('paymentMethods', models.ManyToManyField(blank=True, help_text='If you would like separate buttons for individual payment methods, then select them here.  If left blank, a single button will be shown and no payment method will be specified.', to='register.DoorRegisterPaymentMethod', verbose_name='Payment Methods')),
                ('seriesCategories', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.SeriesCategory', verbose_name='Limit to series categories')),
            ],
            options={
                'permissions': (('choose_custom_plugin_template', 'Can enter a custom plugin template for plugins with selectable template.'),),
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='DoorRegisterEventPluginChoice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('optionType', models.CharField(choices=[('G', 'Standard registration'), ('D', 'Register as a drop-in'), ('S', 'Register with student designation'), ('C', 'Register with comped designation'), ('V', 'Register with voucher')], default='G', max_length=1, verbose_name='Option type')),
                ('optionLabel', models.CharField(blank=True, help_text='Leave blank for default labeling to be applied.', max_length=100, null=True, verbose_name='Override option label')),
                ('optionLocation', models.CharField(choices=[('P', 'Primary choice'), ('A', 'Additional choice')], default='P', help_text='By default, primary choices receive their own button, while additional choices are included in a drop-down menu.', max_length=1, verbose_name='Option location')),
                ('byRole', models.BooleanField(blank=True, default=True, help_text='If disabled, then this option will not be broken out by role. It is not recommended to do this except for drop-in registrations, because the default registration workflow does not allow for later selection of roles.', verbose_name='Separate choices for each role')),
                ('byPaymentMethod', models.BooleanField(blank=True, default=False, help_text='If enabled, then this option will be broken out by the payment methods specified for this plugin. If no payment methods are specified, then this choice will have no effect. It is useful to enable this option when different payment methods require different registration logic.', verbose_name='Separate choices for each payment method')),
                ('requireFullRegistration', models.BooleanField(blank=True, default=True, help_text='If checked, then the user will be sent to the second page of the registration process to provide name and email. Particular payment methods or plugins may also require the full registration process and can override this option.', verbose_name='Require full registration')),
                ('soldOutRule', models.CharField(choices=[('D', 'Display with label'), ('A', 'Move to additional choice drop-down'), ('H', 'Hide sold out choices')], default='D', max_length=1, verbose_name='Rule for sold out choices')),
                ('voucherId', models.CharField(blank=True, max_length=100, null=True, verbose_name='Voucher Code (for registration with a voucher only)')),
                ('data', models.JSONField(blank=True, default=dict, help_text='This may be used for passing specific information about this event registration for statistical or other custom purposes.', verbose_name='Additional data passed with registration')),
                ('order', models.PositiveSmallIntegerField(default=0)),
                ('eventPlugin', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='register.DoorRegisterEventPluginModel', verbose_name='Plugin')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='DoorRegister',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Since there may be more than one at-the-door registration page, give each one a title ', max_length=200, verbose_name='Register title')),
                ('slug', models.SlugField(help_text='Register pages are accessed by a URL based on this slug.', verbose_name='Slug')),
                ('enabled', models.BooleanField(blank=True, default=True, verbose_name='Enable this register page')),
                ('placeholder', cms.models.fields.PlaceholderField(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, slotname='register_placeholder', to='cms.Placeholder')),
            ],
            options={
                'verbose_name': 'At-the-door register',
                'verbose_name_plural': 'At-the-door registers',
                'ordering': ('title',),
            },
        ),
    ]
