# Generated by Django 2.2.6 on 2020-02-11 14:13

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0033_auto_20200124_1349'),
        ('cms', '0022_auto_20180620_1551'),
        ('register', '0005_doorregistereventpluginchoice_registrationopendisplay'),
    ]

    operations = [
        migrations.CreateModel(
            name='DoorRegisterGuestSearchPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='door_doorregisterguestsearchpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('eventType', models.CharField(choices=[('B', 'Class Series and Public Events'), ('S', 'Only Class Series'), ('P', 'Only Public Events')], default='B', max_length=1, verbose_name='Limit to event type')),
                ('limitNumber', models.PositiveSmallIntegerField(blank=True, help_text='Leave blank for no restriction', null=True, verbose_name='Limit number')),
                ('sortOrder', models.CharField(choices=[('A', 'Ascending'), ('D', 'Descending')], default='A', help_text='This may be overridden by the particular template in use', max_length=1, verbose_name='Sort by start time')),
                ('occursWithinDays', models.PositiveSmallIntegerField(blank=True, default=0, help_text='If set, then the register will only include events that have an occurrence within this many days in the future of the register date(usually) the current date. The default of 0 limits to only events that occur on the register date. Leave blank for no restriction.', null=True, verbose_name='Event occurs within __ days')),
                ('limitTypeStart', models.CharField(choices=[('S', 'Event start date'), ('E', 'Event end date')], default='E', max_length=1, verbose_name='Limit interval start by')),
                ('daysStart', models.SmallIntegerField(blank=True, help_text='(E.g. enter -30 for an interval that starts with 30 days prior to today) Leave blank for no limit, or enter 0 to limit to future events', null=True, verbose_name='Interval limited to __ days from present')),
                ('startDate', models.DateField(blank=True, help_text='Leave blank for no limit (overrides relative interval limits)', null=True, verbose_name='Exact interval start date')),
                ('limitTypeEnd', models.CharField(choices=[('S', 'Event start date'), ('E', 'Event end date')], default='S', max_length=1, verbose_name='Limit interval end by')),
                ('daysEnd', models.SmallIntegerField(blank=True, help_text='(E.g. enter 30 for an interval that ends 30 days from today) Leave blank for no limit, or enter 0 to limit to past events', null=True, verbose_name='Interval limited to __ days from present')),
                ('endDate', models.DateField(blank=True, help_text='Leave blank for no limit (overrides relative interval limits)', null=True, verbose_name='Exact interval end date ')),
                ('registrationOpenLimit', models.CharField(choices=[('O', 'Open for registration only'), ('C', 'Closed for registration only'), ('B', 'Both open and closed events')], default='O', max_length=1, verbose_name='Limit to open/closed for registration only')),
                ('weekday', models.PositiveSmallIntegerField(blank=True, choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], null=True, verbose_name='Limit to weekday')),
                ('eventCategories', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.PublicEventCategory', verbose_name='Limit to public event categories')),
                ('levels', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.DanceTypeLevel', verbose_name='Limit to type and levels')),
                ('location', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.Location', verbose_name='Limit to locations')),
                ('seriesCategories', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='core.SeriesCategory', verbose_name='Limit to series categories')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
