"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessApi = void 0;
const cdk = require("@aws-cdk/core");
const apigateway = require("@aws-cdk/aws-apigateway");
const lambda = require("@aws-cdk/aws-lambda");
const path = require("path");
var BREF_LAYER_VERSION;
(function (BREF_LAYER_VERSION) {
    BREF_LAYER_VERSION["PHP_73_FPM"] = "arn:aws:lambda:ap-northeast-1:209497400698:layer:php-73-fpm:24";
    BREF_LAYER_VERSION["PHP_74_FPM"] = "arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:10";
    BREF_LAYER_VERSION["PHP_73"] = "arn:aws:lambda:ap-northeast-1:209497400698:layer:php-73:24";
    BREF_LAYER_VERSION["PHP_74"] = "arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74:10";
})(BREF_LAYER_VERSION || (BREF_LAYER_VERSION = {}));
class ServerlessApi extends cdk.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const DEFAULT_LAMBDA_ASSET_PATH = path.join(__dirname, '../composer/laravel58-bref');
        this.handler = (_a = props === null || props === void 0 ? void 0 : props.handler) !== null && _a !== void 0 ? _a : new lambda.Function(this, 'handler', {
            runtime: lambda.Runtime.PROVIDED,
            handler: 'public/index.php',
            layers: [
                lambda.LayerVersion.fromLayerVersionArn(this, 'BrefPHPLayer', BREF_LAYER_VERSION.PHP_74_FPM),
            ],
            code: lambda.Code.fromAsset((_b = props === null || props === void 0 ? void 0 : props.lambdaCodePath) !== null && _b !== void 0 ? _b : DEFAULT_LAMBDA_ASSET_PATH),
            environment: {
                APP_STORAGE: '/tmp',
            },
            timeout: cdk.Duration.seconds(120),
        });
        new apigateway.LambdaRestApi(this, 'apiservice', {
            handler: this.handler,
        });
    }
}
exports.ServerlessApi = ServerlessApi;
//# sourceMappingURL=data:application/json;base64,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