# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['click_extra', 'click_extra.tests']

package_data = \
{'': ['*']}

install_requires = \
['boltons>=21.0.0,<22.0.0',
 'cli-helpers>=2.2.0,<3.0.0',
 'click-log>=0.3.2,<0.4.0',
 'click>=8.0.2,<9.0.0',
 'cloup>=0.12.1,<0.13.0',
 'pyyaml>=6.0.0,<7.0.0',
 'requests>=2.27.1,<3.0.0',
 'tabulate[widechars]>=0.8.9,<0.9.0',
 'tomli>=2.0.0,<3.0.0']

setup_kwargs = {
    'name': 'click-extra',
    'version': '1.4.1',
    'description': '🌈 Extra colorization and configuration file for Click.',
    'long_description': '# Click Extra\n\n[![Last release](https://img.shields.io/pypi/v/click-extra.svg)](https://pypi.python.org/pypi/click-extra)\n[![Python versions](https://img.shields.io/pypi/pyversions/click-extra.svg)](https://pypi.python.org/pypi/click-extra)\n[![Unittests status](https://github.com/kdeldycke/click-extra/actions/workflows/tests.yaml/badge.svg?branch=main)](https://github.com/kdeldycke/click-extra/actions/workflows/tests.yaml?query=branch%3Amain)\n[![Coverage status](https://codecov.io/gh/kdeldycke/click-extra/branch/main/graph/badge.svg)](https://codecov.io/gh/kdeldycke/click-extra/branch/main)\n\n**What is Click Extra?**\n\n`click-extra` is a collection of helpers and utilities for\n[Click](https://click.palletsprojects.com), the Python CLI framework.\n\nIt provides boilerplate code and good defaults, as well as some workarounds and\npatches that have not reached upstream yet (or are unlikely to).\n\n## Features\n\n- TOML and YAML configuration file loader\n- Colorization of help screens\n- `--color/--no-color` option flag\n- Colored `--version` option\n- Colored `--verbosity` option and logs\n- `--time/--no-time` flag to measure duration of command execution\n- Platform recognition utilities (macOS, Linux and Windows)\n- New conditional markers for `pytest`:\n  - `@skip_linux`, `@skip_macos` and `@skip_windows`\n  - `@unless_linux`, `@unless_macos` and `@unless_windows`\n  - `@destructive` and `@non_destructive`\n\n## Installation\n\nInstall `click-extra` with `pip`:\n\n```shell-session\n$ pip install click-extra\n```\n\n## Configuration loader usage\n\n### TOML configuration\n\nGiven this CLI in a `my_cli.py` file:\n\n```python\nimport click\n\nfrom click_extra.config import config_option\n\n\n@click.group(context_settings={"show_default": True})\n@click.option("--dummy-flag/--no-flag")\n@click.option("--my-list", multiple=True)\n@config_option()\ndef my_cli(dummy_flag, my_list):\n    click.echo(f"dummy_flag    is {dummy_flag!r}")\n    click.echo(f"my_list       is {my_list!r}")\n\n\n@my_cli.command()\n@click.option("--int-param", type=int, default=10)\ndef subcommand(int_param):\n    click.echo(f"int_parameter is {int_param!r}")\n\n\nif __name__ == "__main__":\n    my_cli()\n```\n\nIt produces the following help screens:\n\n```shell-session\n$ python ./my_cli.py\nUsage: my_cli.py [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --dummy-flag / --no-flag  [default: no-flag]\n  --my-list TEXT\n  -C, --config CONFIG_PATH  Location of the configuration file. Supports both\n                            local path and remote URL.  [default: s(dynamic)]\n  --help                    Show this message and exit.  [default: False]\n\nCommands:\n  subcommand\n```\n\nA bare call returns:\n\n```shell-session\n$ ./my_cli.py subcommand\ndummy_flag    is False\nmy_list       is ()\nint_parameter is 10\n```\n\nNow we will change the default CLI output by creating a TOML file at\n`~/.my_cli.py/config.toml` which contains:\n\n```toml\n# My default configuration file.\ntop_level_param = "is_ignored"\n\n[my-cli]\nextra_value = "is ignored too"\ndummy_flag = true   # New boolean default.\nmy_list = ["item 1", "item #2", "Very Last Item!"]\n\n[garbage]\n# An empty random section that will be skipped\n\n[my-cli.subcommand]\nint_param = 3\nrandom_stuff = "will be ignored"\n```\n\nIn the file above, pay attention to:\n\n- the configuration\'s folder (`~/.my_cli.py/`) which correspond to the script\'s\n  name (`my_cli.py`);\n- the top-level config section (`[my-cli]`), that is derived from the CLI\'s\n  group ID (`def my_cli()`);\n- all the extra comments, sections and values that will be silently ignored.\n\nNow we can verify the TOML file is read automatticaly and change the defaults:\n\n```shell-session\n$ ./my_cli.py subcommand\ndummy_flag    is True\nmy_list       is (\'item 1\', \'item #2\', \'Very Last Item!\')\nint_parameter is 3\n```\n\nStill, any inline parameter is allowedal to ovverides the configuration\ndefaults:\n\n```shell-session\n$ ./my_cli.py subcommand --int-param 555\ndummy_flag    is True\nmy_list       is (\'item 1\', \'item #2\', \'Very Last Item!\')\nint_parameter is 555\n```\n\n### YAML configuration\n\nSame example as above is working as-is with YAML.\n\nJust replace the TOML file with the following configuration at\n`~/.my_cli.py/config.yaml`:\n\n```yaml\n# My default configuration file.\ntop_level_param: is_ignored\n\nmy-cli:\n  extra_value: is ignored too\n  dummy_flag: true   # New boolean default.\n  my_list:\n    - point 1\n    - \'point #2\'\n    - Very Last Point!\n\n  subcommand:\n    int_param: 77\n    random_stuff: will be ignored\n\ngarbage: >\n  An empty random section that will be skipped\n```\n\n```shell-session\n$ ./my_cli.py --config ~/.my_cli.py/config.yaml subcommand\ndummy_flag    is True\nmy_list       is (\'point 1\', \'point #2\', \'Very Last Point!\')\nint_parameter is 77\n```\n\n### Remote configuration\n\nRemote URL can be passed directly to the `--config` option:\n\n```shell-session\n$ ./my_cli.py --config https://example.com/dummy/configuration.yaml subcommand\ndummy_flag    is True\nmy_list       is (\'point 1\', \'point #2\', \'Very Last Point!\')\nint_parameter is 77\n```\n\n## Colorization of help screen\n\nExtend\n[Cloup\'s own help formatter and theme](https://cloup.readthedocs.io/en/stable/pages/formatting.html#help-formatting-and-themes)\nto add colorization of:\n\n- Options\n- Choices\n- Metavars\n\n## Used in\n\nCheck these projects to get real-life example of `click-extra` usage:\n\n- [Mail Deduplicate](https://github.com/kdeldycke/mail-deduplicate#readme) - A\n  CLI to deduplicate similar emails.\n- [Meta Package Manager](https://github.com/kdeldycke/meta-package-manager#readme)\n  \\- A unifying CLI for multiple package managers.\n\n## Issues addressed by `click-extra`\n\nKeep track of things to undo if they reach upstream.\n\n[`click`](https://github.com/pallets/click):\n\n- [`#2111` - `Context.color = False` doesn\'t overrides `echo(color=True)`](https://github.com/pallets/click/issues/2111)\n- [`#2110` - `testing.CliRunner.invoke` cannot pass color for `Context` instantiation](https://github.com/pallets/click/issues/2110)\n\n[`click-config-file`](https://github.com/phha/click_config_file):\n\n- [`#9` - Additional configuration providers](https://github.com/phha/click_config_file/issues/9)\n\n[`click-help-color`](https://github.com/click-contrib/click-help-colors):\n\n- [`#17` - Highlighting of options, choices and metavars](https://github.com/click-contrib/click-help-colors/issues/17)\n\n[`click-log`](https://github.com/click-contrib/click-log):\n\n- [`#30` - Add a `no-color` option, method or parameter to disable colouring globally](https://github.com/click-contrib/click-log/issues/30)\n- [`#29` - Log level is leaking between invokations: hack to force-reset it](https://github.com/click-contrib/click-log/issues/29)\n- [`#24` - Add missing string interpolation in error message](https://github.com/click-contrib/click-log/pull/24)\n- [`#18` - Add trailing dot to help text](https://github.com/click-contrib/click-log/pull/18)\n\n[`cli-helper`](https://github.com/dbcli/cli_helpers):\n\n- [`#79` -Replace local tabulate formats with those available upstream](https://github.com/dbcli/cli_helpers/issues/79)\n\n[`cloup`](https://github.com/janluke/cloup):\n\n- [`#98` - Add support for option groups on `cloup.Group`](https://github.com/janluke/cloup/issues/98)\n- [`#97` - Styling metavars, default values, env var, choices](https://github.com/janluke/cloup/issues/97)\n- [`#95` - Highlights options, choices and metavars](https://github.com/janluke/cloup/issues/95)\n- [`#96` - Add loading of options from a TOML configuration file](https://github.com/janluke/cloup/issues/96)\n\n[`python-tabulate`](https://github.com/astanin/python-tabulate):\n\n- [`#151` - Add new {`rounded`,`simple`,`double`}\\_(`grid`,`outline`} formats](https://github.com/astanin/python-tabulate/pull/151)\n\n## Dependencies\n\nHere is a graph of Python package dependencies:\n\n![click-extra dependency graph](https://github.com/kdeldycke/click-extra/raw/main/dependencies.png)\n\n## Development\n\n[Development guidelines](https://kdeldycke.github.io/meta-package-manager/development.html)\nare the same as\n[parent project `mpm`](https://github.com/kdeldycke/meta-package-manager), from\nwhich `click-extra` originated.\n',
    'author': 'Kevin Deldycke',
    'author_email': 'kevin@deldycke.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kdeldycke/click-extra',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
