import setuptools

with open('README.md', 'r', encoding='utf-8') as fh:
    long_description = fh.read()

setuptools.setup(
    name='rushd',
    version='0.0.2',
    author='Christopher Johnstone',
    author_email='meson800@gmail.com',
    description='Package for maintaining robust, reproducible data management.',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/GallowayLabMIT/rushd',
    project_urls={
        'Bug Tracker': 'https://github.com/GallowayLabMIT/rushd/issues',
    },
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Topic :: Scientific/Engineering',
        'Topic :: Utilities'
    ],
    package_dir={'': 'src'},
    packages=setuptools.find_packages(where='src'),
    python_requires=">=3.7",
    install_requires=[
        'pyyaml',
    ],
    extras_require={
        'dev': [
            'pytest',
            'pytest-pep8',
            'pytest-cov',
            'pylint',
            'build',
            'twine',
        ]
    }
)