"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_AwsIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.string({
                produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        arnFormat: core_1.ArnFormat.SLASH_RESOURCE_NAME,
                        resourceName: apiValue,
                        region: props.region,
                    });
                },
            }),
            options: props.options,
        });
    }
    bind(method) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_Method(method);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const bindResult = super.bind(method);
        this.scope = method;
        return bindResult;
    }
}
exports.AwsIntegration = AwsIntegration;
_a = JSII_RTTI_SYMBOL_1;
AwsIntegration[_a] = { fqn: "@aws-cdk/aws-apigateway.AwsIntegration", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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