"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Model = exports.ErrorModel = exports.EmptyModel = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
const util = require("./util");
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 * @deprecated You should use Model.EMPTY_MODEL
 */
class EmptyModel {
    constructor() {
        this.modelId = 'Empty';
    }
}
exports.EmptyModel = EmptyModel;
_a = JSII_RTTI_SYMBOL_1;
EmptyModel[_a] = { fqn: "@aws-cdk/aws-apigateway.EmptyModel", version: "1.158.0" };
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 * @deprecated You should use Model.ERROR_MODEL
 */
class ErrorModel {
    constructor() {
        this.modelId = 'Error';
    }
}
exports.ErrorModel = ErrorModel;
_b = JSII_RTTI_SYMBOL_1;
ErrorModel[_b] = { fqn: "@aws-cdk/aws-apigateway.ErrorModel", version: "1.158.0" };
class Model extends core_1.Resource {
    constructor(scope, id, props) {
        var _d;
        super(scope, id, {
            physicalName: props.modelName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_ModelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const modelProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            contentType: (_d = props.contentType) !== null && _d !== void 0 ? _d : 'application/json',
            description: props.description,
            schema: util.JsonSchemaMapper.toCfnJsonSchema(props.schema),
        };
        const resource = new apigateway_generated_1.CfnModel(this, 'Resource', modelProps);
        this.modelId = this.getResourceNameAttribute(resource.ref);
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ model: modelProps });
        }
    }
    static fromModelName(scope, id, modelName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.modelId = modelName;
            }
        }
        return new Import(scope, id);
    }
}
exports.Model = Model;
_c = JSII_RTTI_SYMBOL_1;
Model[_c] = { fqn: "@aws-cdk/aws-apigateway.Model", version: "1.158.0" };
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 */
Model.ERROR_MODEL = new ErrorModel();
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 */
Model.EMPTY_MODEL = new EmptyModel();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kZWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtb2RlbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBeUM7QUFFekMsaUVBQWlFO0FBRWpFLHVDQUE4QztBQUM5QywrQkFBK0I7QUFXL0I7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBaUJHO0FBQ0gsTUFBYSxVQUFVO0lBQXZCO1FBQ2tCLFlBQU8sR0FBRyxPQUFPLENBQUM7S0FDbkM7O0FBRkQsZ0NBRUM7OztBQUVEOzs7Ozs7Ozs7Ozs7Ozs7O0dBZ0JHO0FBQ0gsTUFBYSxVQUFVO0lBQXZCO1FBQ2tCLFlBQU8sR0FBRyxPQUFPLENBQUM7S0FDbkM7O0FBRkQsZ0NBRUM7OztBQW9ERCxNQUFhLEtBQU0sU0FBUSxlQUFRO0lBcURqQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWlCOztRQUN6RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxLQUFLLENBQUMsU0FBUztTQUM5QixDQUFDLENBQUM7Ozs7Ozs7Ozs7UUFFSCxNQUFNLFVBQVUsR0FBa0I7WUFDaEMsSUFBSSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQ3ZCLFNBQVMsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVM7WUFDbEMsV0FBVyxRQUFFLEtBQUssQ0FBQyxXQUFXLG1DQUFJLGtCQUFrQjtZQUNwRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsTUFBTSxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUM1RCxDQUFDO1FBRUYsTUFBTSxRQUFRLEdBQUcsSUFBSSwrQkFBUSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFFNUQsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBRTNELE1BQU0sVUFBVSxHQUFHLENBQUMsS0FBSyxDQUFDLE9BQU8sWUFBWSxpQkFBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUNuRyxJQUFJLFVBQVUsRUFBRTtZQUNkLFVBQVUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3hDLFVBQVUsQ0FBQyxjQUFjLENBQUMsRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLENBQUMsQ0FBQztTQUNsRDtLQUNGO0lBckNNLE1BQU0sQ0FBQyxhQUFhLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsU0FBaUI7UUFDekUsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ2tCLFlBQU8sR0FBRyxTQUFTLENBQUM7WUFDdEMsQ0FBQztTQUFBO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7O0FBNUNILHNCQTRFQzs7O0FBM0VDOzs7Ozs7Ozs7Ozs7Ozs7R0FlRztBQUNvQixpQkFBVyxHQUFXLElBQUksVUFBVSxFQUFFLENBQUM7QUFFOUQ7Ozs7Ozs7Ozs7Ozs7Ozs7R0FnQkc7QUFDb0IsaUJBQVcsR0FBVyxJQUFJLFVBQVUsRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuTW9kZWwsIENmbk1vZGVsUHJvcHMgfSBmcm9tICcuL2FwaWdhdGV3YXkuZ2VuZXJhdGVkJztcbmltcG9ydCAqIGFzIGpzb25TY2hlbWEgZnJvbSAnLi9qc29uLXNjaGVtYSc7XG5pbXBvcnQgeyBJUmVzdEFwaSwgUmVzdEFwaSB9IGZyb20gJy4vcmVzdGFwaSc7XG5pbXBvcnQgKiBhcyB1dGlsIGZyb20gJy4vdXRpbCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgSU1vZGVsIHtcbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIG1vZGVsIG5hbWUsIHN1Y2ggYXMgJ215TW9kZWwnXG4gICAqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IG1vZGVsSWQ6IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgcmVmZXJlbmNlIHRvIGEgUkVTVCBBUEkncyBFbXB0eSBtb2RlbCwgd2hpY2ggaXMgYXZhaWxhYmxlXG4gKiBhcyBwYXJ0IG9mIHRoZSBtb2RlbCBjb2xsZWN0aW9uIGJ5IGRlZmF1bHQuIFRoaXMgY2FuIGJlIHVzZWQgZm9yIG1hcHBpbmdcbiAqIEpTT04gcmVzcG9uc2VzIGZyb20gYW4gaW50ZWdyYXRpb24gdG8gd2hhdCBpcyByZXR1cm5lZCB0byBhIGNsaWVudCxcbiAqIHdoZXJlIHN0cm9uZyB0eXBpbmcgaXMgbm90IHJlcXVpcmVkLiBJbiB0aGUgYWJzZW5jZSBvZiBhbnkgZGVmaW5lZFxuICogbW9kZWwsIHRoZSBFbXB0eSBtb2RlbCB3aWxsIGJlIHVzZWQgdG8gcmV0dXJuIHRoZSByZXNwb25zZSBwYXlsb2FkXG4gKiB1bm1hcHBlZC5cbiAqXG4gKiBEZWZpbml0aW9uXG4gKiB7XG4gKiAgIFwiJHNjaGVtYVwiIDogXCJodHRwOi8vanNvbi1zY2hlbWEub3JnL2RyYWZ0LTA0L3NjaGVtYSNcIixcbiAqICAgXCJ0aXRsZVwiIDogXCJFbXB0eSBTY2hlbWFcIixcbiAqICAgXCJ0eXBlXCIgOiBcIm9iamVjdFwiXG4gKiB9XG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYW1hem9uYXdzLmNuL2VuX3VzL2FwaWdhdGV3YXkvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL21vZGVscy1tYXBwaW5ncy5odG1sI21vZGVscy1tYXBwaW5ncy1tb2RlbHNcbiAqIEBkZXByZWNhdGVkIFlvdSBzaG91bGQgdXNlIE1vZGVsLkVNUFRZX01PREVMXG4gKi9cbmV4cG9ydCBjbGFzcyBFbXB0eU1vZGVsIGltcGxlbWVudHMgSU1vZGVsIHtcbiAgcHVibGljIHJlYWRvbmx5IG1vZGVsSWQgPSAnRW1wdHknO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSByZWZlcmVuY2UgdG8gYSBSRVNUIEFQSSdzIEVycm9yIG1vZGVsLCB3aGljaCBpcyBhdmFpbGFibGVcbiAqIGFzIHBhcnQgb2YgdGhlIG1vZGVsIGNvbGxlY3Rpb24gYnkgZGVmYXVsdC4gVGhpcyBjYW4gYmUgdXNlZCBmb3IgbWFwcGluZ1xuICogZXJyb3IgSlNPTiByZXNwb25zZXMgZnJvbSBhbiBpbnRlZ3JhdGlvbiB0byBhIGNsaWVudCwgd2hlcmUgYSBzaW1wbGVcbiAqIGdlbmVyaWMgbWVzc2FnZSBmaWVsZCBpcyBzdWZmaWNpZW50IHRvIG1hcCBhbmQgcmV0dXJuIGFuIGVycm9yIHBheWxvYWQuXG4gKlxuICogRGVmaW5pdGlvblxuICoge1xuICogICBcIiRzY2hlbWFcIiA6IFwiaHR0cDovL2pzb24tc2NoZW1hLm9yZy9kcmFmdC0wNC9zY2hlbWEjXCIsXG4gKiAgIFwidGl0bGVcIiA6IFwiRXJyb3IgU2NoZW1hXCIsXG4gKiAgIFwidHlwZVwiIDogXCJvYmplY3RcIixcbiAqICAgXCJwcm9wZXJ0aWVzXCIgOiB7XG4gKiAgICAgXCJtZXNzYWdlXCIgOiB7IFwidHlwZVwiIDogXCJzdHJpbmdcIiB9XG4gKiAgIH1cbiAqIH1cbiAqIEBkZXByZWNhdGVkIFlvdSBzaG91bGQgdXNlIE1vZGVsLkVSUk9SX01PREVMXG4gKi9cbmV4cG9ydCBjbGFzcyBFcnJvck1vZGVsIGltcGxlbWVudHMgSU1vZGVsIHtcbiAgcHVibGljIHJlYWRvbmx5IG1vZGVsSWQgPSAnRXJyb3InO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1vZGVsT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgY29udGVudCB0eXBlIGZvciB0aGUgbW9kZWwuIFlvdSBjYW4gYWxzbyBmb3JjZSBhXG4gICAqIGNvbnRlbnQgdHlwZSBpbiB0aGUgcmVxdWVzdCBvciByZXNwb25zZSBtb2RlbCBtYXBwaW5nLlxuICAgKlxuICAgKiBAZGVmYXVsdCAnYXBwbGljYXRpb24vanNvbidcbiAgICovXG4gIHJlYWRvbmx5IGNvbnRlbnRUeXBlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIGRlc2NyaXB0aW9uIHRoYXQgaWRlbnRpZmllcyB0aGlzIG1vZGVsLlxuICAgKiBAZGVmYXVsdCBOb25lXG4gICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogQSBuYW1lIGZvciB0aGUgbW9kZWwuXG4gICAqXG4gICAqIEltcG9ydGFudFxuICAgKiAgSWYgeW91IHNwZWNpZnkgYSBuYW1lLCB5b3UgY2Fubm90IHBlcmZvcm0gdXBkYXRlcyB0aGF0XG4gICAqICByZXF1aXJlIHJlcGxhY2VtZW50IG9mIHRoaXMgcmVzb3VyY2UuIFlvdSBjYW4gcGVyZm9ybVxuICAgKiAgdXBkYXRlcyB0aGF0IHJlcXVpcmUgbm8gb3Igc29tZSBpbnRlcnJ1cHRpb24uIElmIHlvdVxuICAgKiAgbXVzdCByZXBsYWNlIHRoZSByZXNvdXJjZSwgc3BlY2lmeSBhIG5ldyBuYW1lLlxuICAgKlxuICAgKiBAZGVmYXVsdCA8YXV0bz4gSWYgeW91IGRvbid0IHNwZWNpZnkgYSBuYW1lLFxuICAgKiAgQVdTIENsb3VkRm9ybWF0aW9uIGdlbmVyYXRlcyBhIHVuaXF1ZSBwaHlzaWNhbCBJRCBhbmRcbiAgICogIHVzZXMgdGhhdCBJRCBmb3IgdGhlIG1vZGVsIG5hbWUuIEZvciBtb3JlIGluZm9ybWF0aW9uLFxuICAgKiAgc2VlIE5hbWUgVHlwZS5cbiAgICovXG4gIHJlYWRvbmx5IG1vZGVsTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHNjaGVtYSB0byB1c2UgdG8gdHJhbnNmb3JtIGRhdGEgdG8gb25lIG9yIG1vcmUgb3V0cHV0IGZvcm1hdHMuXG4gICAqIFNwZWNpZnkgbnVsbCAoe30pIGlmIHlvdSBkb24ndCB3YW50IHRvIHNwZWNpZnkgYSBzY2hlbWEuXG4gICAqL1xuICByZWFkb25seSBzY2hlbWE6IGpzb25TY2hlbWEuSnNvblNjaGVtYTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBNb2RlbFByb3BzIGV4dGVuZHMgTW9kZWxPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSByZXN0IEFQSSB0aGF0IHRoaXMgbW9kZWwgaXMgcGFydCBvZi5cbiAgICpcbiAgICogVGhlIHJlYXNvbiB3ZSBuZWVkIHRoZSBSZXN0QXBpIG9iamVjdCBpdHNlbGYgYW5kIG5vdCBqdXN0IHRoZSBJRCBpcyBiZWNhdXNlIHRoZSBtb2RlbFxuICAgKiBpcyBiZWluZyB0cmFja2VkIGJ5IHRoZSB0b3AtbGV2ZWwgUmVzdEFwaSBvYmplY3QgZm9yIHRoZSBwdXJwb3NlIG9mIGNhbGN1bGF0aW5nIGl0J3NcbiAgICogaGFzaCB0byBkZXRlcm1pbmUgdGhlIElEIG9mIHRoZSBkZXBsb3ltZW50LiBUaGlzIGFsbG93cyB1cyB0byBhdXRvbWF0aWNhbGx5IHVwZGF0ZVxuICAgKiB0aGUgZGVwbG95bWVudCB3aGVuIHRoZSBtb2RlbCBvZiB0aGUgUkVTVCBBUEkgY2hhbmdlcy5cbiAgICovXG4gIHJlYWRvbmx5IHJlc3RBcGk6IElSZXN0QXBpO1xufVxuXG5leHBvcnQgY2xhc3MgTW9kZWwgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElNb2RlbCB7XG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIGEgcmVmZXJlbmNlIHRvIGEgUkVTVCBBUEkncyBFcnJvciBtb2RlbCwgd2hpY2ggaXMgYXZhaWxhYmxlXG4gICAqIGFzIHBhcnQgb2YgdGhlIG1vZGVsIGNvbGxlY3Rpb24gYnkgZGVmYXVsdC4gVGhpcyBjYW4gYmUgdXNlZCBmb3IgbWFwcGluZ1xuICAgKiBlcnJvciBKU09OIHJlc3BvbnNlcyBmcm9tIGFuIGludGVncmF0aW9uIHRvIGEgY2xpZW50LCB3aGVyZSBhIHNpbXBsZVxuICAgKiBnZW5lcmljIG1lc3NhZ2UgZmllbGQgaXMgc3VmZmljaWVudCB0byBtYXAgYW5kIHJldHVybiBhbiBlcnJvciBwYXlsb2FkLlxuICAgKlxuICAgKiBEZWZpbml0aW9uXG4gICAqIHtcbiAgICogICBcIiRzY2hlbWFcIiA6IFwiaHR0cDovL2pzb24tc2NoZW1hLm9yZy9kcmFmdC0wNC9zY2hlbWEjXCIsXG4gICAqICAgXCJ0aXRsZVwiIDogXCJFcnJvciBTY2hlbWFcIixcbiAgICogICBcInR5cGVcIiA6IFwib2JqZWN0XCIsXG4gICAqICAgXCJwcm9wZXJ0aWVzXCIgOiB7XG4gICAqICAgICBcIm1lc3NhZ2VcIiA6IHsgXCJ0eXBlXCIgOiBcInN0cmluZ1wiIH1cbiAgICogICB9XG4gICAqIH1cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRVJST1JfTU9ERUw6IElNb2RlbCA9IG5ldyBFcnJvck1vZGVsKCk7XG5cbiAgLyoqXG4gICAqIFJlcHJlc2VudHMgYSByZWZlcmVuY2UgdG8gYSBSRVNUIEFQSSdzIEVtcHR5IG1vZGVsLCB3aGljaCBpcyBhdmFpbGFibGVcbiAgICogYXMgcGFydCBvZiB0aGUgbW9kZWwgY29sbGVjdGlvbiBieSBkZWZhdWx0LiBUaGlzIGNhbiBiZSB1c2VkIGZvciBtYXBwaW5nXG4gICAqIEpTT04gcmVzcG9uc2VzIGZyb20gYW4gaW50ZWdyYXRpb24gdG8gd2hhdCBpcyByZXR1cm5lZCB0byBhIGNsaWVudCxcbiAgICogd2hlcmUgc3Ryb25nIHR5cGluZyBpcyBub3QgcmVxdWlyZWQuIEluIHRoZSBhYnNlbmNlIG9mIGFueSBkZWZpbmVkXG4gICAqIG1vZGVsLCB0aGUgRW1wdHkgbW9kZWwgd2lsbCBiZSB1c2VkIHRvIHJldHVybiB0aGUgcmVzcG9uc2UgcGF5bG9hZFxuICAgKiB1bm1hcHBlZC5cbiAgICpcbiAgICogRGVmaW5pdGlvblxuICAgKiB7XG4gICAqICAgXCIkc2NoZW1hXCIgOiBcImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDQvc2NoZW1hI1wiLFxuICAgKiAgIFwidGl0bGVcIiA6IFwiRW1wdHkgU2NoZW1hXCIsXG4gICAqICAgXCJ0eXBlXCIgOiBcIm9iamVjdFwiXG4gICAqIH1cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYW1hem9uYXdzLmNuL2VuX3VzL2FwaWdhdGV3YXkvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL21vZGVscy1tYXBwaW5ncy5odG1sI21vZGVscy1tYXBwaW5ncy1tb2RlbHNcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRU1QVFlfTU9ERUw6IElNb2RlbCA9IG5ldyBFbXB0eU1vZGVsKCk7XG5cbiAgcHVibGljIHN0YXRpYyBmcm9tTW9kZWxOYW1lKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIG1vZGVsTmFtZTogc3RyaW5nKTogSU1vZGVsIHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElNb2RlbCB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgbW9kZWxJZCA9IG1vZGVsTmFtZTtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIG1vZGVsIG5hbWUsIHN1Y2ggYXMgJ215TW9kZWwnXG4gICAqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBtb2RlbElkOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE1vZGVsUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBoeXNpY2FsTmFtZTogcHJvcHMubW9kZWxOYW1lLFxuICAgIH0pO1xuXG4gICAgY29uc3QgbW9kZWxQcm9wczogQ2ZuTW9kZWxQcm9wcyA9IHtcbiAgICAgIG5hbWU6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgcmVzdEFwaUlkOiBwcm9wcy5yZXN0QXBpLnJlc3RBcGlJZCxcbiAgICAgIGNvbnRlbnRUeXBlOiBwcm9wcy5jb250ZW50VHlwZSA/PyAnYXBwbGljYXRpb24vanNvbicsXG4gICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICBzY2hlbWE6IHV0aWwuSnNvblNjaGVtYU1hcHBlci50b0Nmbkpzb25TY2hlbWEocHJvcHMuc2NoZW1hKSxcbiAgICB9O1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuTW9kZWwodGhpcywgJ1Jlc291cmNlJywgbW9kZWxQcm9wcyk7XG5cbiAgICB0aGlzLm1vZGVsSWQgPSB0aGlzLmdldFJlc291cmNlTmFtZUF0dHJpYnV0ZShyZXNvdXJjZS5yZWYpO1xuXG4gICAgY29uc3QgZGVwbG95bWVudCA9IChwcm9wcy5yZXN0QXBpIGluc3RhbmNlb2YgUmVzdEFwaSkgPyBwcm9wcy5yZXN0QXBpLmxhdGVzdERlcGxveW1lbnQgOiB1bmRlZmluZWQ7XG4gICAgaWYgKGRlcGxveW1lbnQpIHtcbiAgICAgIGRlcGxveW1lbnQubm9kZS5hZGREZXBlbmRlbmN5KHJlc291cmNlKTtcbiAgICAgIGRlcGxveW1lbnQuYWRkVG9Mb2dpY2FsSWQoeyBtb2RlbDogbW9kZWxQcm9wcyB9KTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==