"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("@aws-cdk/aws-stepfunctions");
const _1 = require(".");
const stepfunctions_1 = require("./integrations/stepfunctions");
/**
 * Defines an API Gateway REST API with a Synchrounous Express State Machine as a proxy integration.
 */
class StepFunctionsRestApi extends _1.RestApi {
    constructor(scope, id, props) {
        var _b, _c;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_StepFunctionsRestApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Step Functions integration is automatically defined');
        }
        if (props.stateMachine.node.defaultChild.stateMachineType !== sfn.StateMachineType.EXPRESS) {
            throw new Error('State Machine must be of type "EXPRESS". Please use StateMachineType.EXPRESS as the stateMachineType');
        }
        const stepfunctionsIntegration = stepfunctions_1.StepFunctionsIntegration.startExecution(props.stateMachine, {
            credentialsRole: props.role,
            requestContext: props.requestContext,
            path: (_b = props.path) !== null && _b !== void 0 ? _b : true,
            querystring: (_c = props.querystring) !== null && _c !== void 0 ? _c : true,
            headers: props.headers,
            authorizer: props.authorizer,
        });
        super(scope, id, props);
        this.root.addMethod('ANY', stepfunctionsIntegration);
    }
}
exports.StepFunctionsRestApi = StepFunctionsRestApi;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.StepFunctionsRestApi", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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