# wire4-client
Referencia de API. La API de Wire4 está organizada en torno a REST

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.11
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import wire4_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import wire4_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import wire4_client
from wire4_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = wire4_client.AutorizacinDeDepsitosApi(wire4_client.ApiClient(configuration))
authorization = 'authorization_example' # str | Header para token
subscription = 'subscription_example' # str | Es el identificador de la suscripción a esta API.

try:
    # Consulta autorización de depósitos
    api_response = api_instance.get_deposit_auth_configurations(authorization, subscription)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AutorizacinDeDepsitosApi->get_deposit_auth_configurations: %s\n" % e)

# create an instance of the API class
api_instance = wire4_client.AutorizacinDeDepsitosApi(wire4_client.ApiClient(configuration))
body = wire4_client.DepositAuthorizationRequest() # DepositAuthorizationRequest | Información para habilitar / deshabilitar la autorización de depósito
authorization = 'authorization_example' # str | Header para token
subscription = 'subscription_example' # str | Es el identificador de la suscripción a esta API.

try:
    # Habilita / Deshabilita la autorización de depósitos
    api_response = api_instance.put_deposit_auth_configurations(body, authorization, subscription)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AutorizacinDeDepsitosApi->put_deposit_auth_configurations: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://sandbox-api.wire4.mx/wire4/1.0.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AutorizacinDeDepsitosApi* | [**get_deposit_auth_configurations**](docs/AutorizacinDeDepsitosApi.md#get_deposit_auth_configurations) | **GET** /subscriptions/{subscription}/configurations/deposit-authorization | Consulta autorización de depósitos
*AutorizacinDeDepsitosApi* | [**put_deposit_auth_configurations**](docs/AutorizacinDeDepsitosApi.md#put_deposit_auth_configurations) | **PUT** /subscriptions/{subscription}/configurations/deposit-authorization | Habilita / Deshabilita la autorización de depósitos
*ComprobanteElectrnicoDePagoCEPApi* | [**obtain_transaction_cep_using_post**](docs/ComprobanteElectrnicoDePagoCEPApi.md#obtain_transaction_cep_using_post) | **POST** /ceps | Consulta de CEP
*ContactoApi* | [**send_contact_using_post**](docs/ContactoApi.md#send_contact_using_post) | **POST** /contact | Solicitud de contacto
*ContractsDetailsApi* | [**create_authorization**](docs/ContractsDetailsApi.md#create_authorization) | **POST** /onboarding/accounts/authorize | Devuelve la URL para autorización del usuario Monex
*ContractsDetailsApi* | [**obtain_authorized_users**](docs/ContractsDetailsApi.md#obtain_authorized_users) | **GET** /onboarding/accounts/{requestId}/authorized-users | Obtiene los usuarios autorizados
*ContractsDetailsApi* | [**obtain_authorized_users_by_contract**](docs/ContractsDetailsApi.md#obtain_authorized_users_by_contract) | **GET** /onboarding/accounts/authorized-users | Obtiene los usuarios autorizados por contrato
*ContractsDetailsApi* | [**obtain_contract_details**](docs/ContractsDetailsApi.md#obtain_contract_details) | **POST** /onboarding/accounts/details | Obtiene los detalles de la empresa del contrato
*CuentasDeBeneficiariosSPEIApi* | [**authorize_accounts_pending_put**](docs/CuentasDeBeneficiariosSPEIApi.md#authorize_accounts_pending_put) | **PUT** /subscriptions/{subscription}/beneficiaries/pending | Solicitud para agrupar cuentas de beneficiarios SPEI/SPID en estado pendiente.
*CuentasDeBeneficiariosSPEIApi* | [**delete_account_using_delete**](docs/CuentasDeBeneficiariosSPEIApi.md#delete_account_using_delete) | **DELETE** /subscriptions/{subscription}/beneficiaries/spei/{account} | Elimina la cuenta del beneficiario
*CuentasDeBeneficiariosSPEIApi* | [**get_available_relationships_monex_using_get**](docs/CuentasDeBeneficiariosSPEIApi.md#get_available_relationships_monex_using_get) | **GET** /subscriptions/{subscription}/beneficiaries/relationships | Consulta de relaciones
*CuentasDeBeneficiariosSPEIApi* | [**get_beneficiaries_by_request_id**](docs/CuentasDeBeneficiariosSPEIApi.md#get_beneficiaries_by_request_id) | **GET** /subscriptions/{subscription}/beneficiaries/spei/{requestId} | Consulta los beneficiarios por el identificador de la petición de registro
*CuentasDeBeneficiariosSPEIApi* | [**get_beneficiaries_for_account_using_get**](docs/CuentasDeBeneficiariosSPEIApi.md#get_beneficiaries_for_account_using_get) | **GET** /subscriptions/{subscription}/beneficiaries/spei | Consulta los beneficiarios registrados
*CuentasDeBeneficiariosSPEIApi* | [**pre_register_accounts_using_post**](docs/CuentasDeBeneficiariosSPEIApi.md#pre_register_accounts_using_post) | **POST** /subscriptions/{subscription}/beneficiaries/spei | Pre-registro de cuentas de beneficiarios SPEI®.
*CuentasDeBeneficiariosSPEIApi* | [**remove_beneficiaries_pending_using_delete**](docs/CuentasDeBeneficiariosSPEIApi.md#remove_beneficiaries_pending_using_delete) | **DELETE** /subscriptions/{subscription}/beneficiaries/spei/request/{requestId} | Eliminación de beneficiarios SPEI® sin confirmar
*CuentasDeBeneficiariosSPEIApi* | [**update_amount_limit_account_using_put**](docs/CuentasDeBeneficiariosSPEIApi.md#update_amount_limit_account_using_put) | **PUT** /subscriptions/{subscription}/beneficiaries/spei/{account} | Solicitud para actualizar el monto límite de una cuenta
*CuentasDeBeneficiariosSPIDApi* | [**get_spid_beneficiaries_for_account**](docs/CuentasDeBeneficiariosSPIDApi.md#get_spid_beneficiaries_for_account) | **GET** /subscriptions/{subscription}/beneficiaries/spid | Consulta los beneficiarios SPID registrados
*CuentasDeBeneficiariosSPIDApi* | [**pre_register_accounts_using_post1**](docs/CuentasDeBeneficiariosSPIDApi.md#pre_register_accounts_using_post1) | **POST** /subscriptions/{subscription}/beneficiaries/spid | Pre-registro de cuentas de beneficiarios SPID®
*DepositantesApi* | [**get_depositants_using_get**](docs/DepositantesApi.md#get_depositants_using_get) | **GET** /subscriptions/{subscription}/depositants | Consulta de cuentas de depositantes
*DepositantesApi* | [**register_depositants_using_post**](docs/DepositantesApi.md#register_depositants_using_post) | **POST** /subscriptions/{subscription}/depositants | Registra un nuevo depositante
*EmpresasCoDiApi* | [**obtain_companies**](docs/EmpresasCoDiApi.md#obtain_companies) | **GET** /codi/companies | Consulta de empresas CODI®
*EmpresasCoDiApi* | [**register_company_using_post**](docs/EmpresasCoDiApi.md#register_company_using_post) | **POST** /codi/companies | Registro de empresas CODI®
*FacturasApi* | [**billings_report_by_id_using_get**](docs/FacturasApi.md#billings_report_by_id_using_get) | **GET** /billings/{id} | Consulta de facturas por identificador
*FacturasApi* | [**billings_report_using_get**](docs/FacturasApi.md#billings_report_using_get) | **GET** /billings | Consulta de facturas
*InstitucionesApi* | [**get_all_institutions_using_get**](docs/InstitucionesApi.md#get_all_institutions_using_get) | **GET** /institutions | Consulta de instituciones bancarias
*LmitesDeMontosApi* | [**obtain_configurations_limits**](docs/LmitesDeMontosApi.md#obtain_configurations_limits) | **GET** /subscriptions/{suscription}/configurations | Consulta de configuraciones
*LmitesDeMontosApi* | [**update_configurations**](docs/LmitesDeMontosApi.md#update_configurations) | **PUT** /subscriptions/{suscription}/configurations | Actualiza configuraciones por suscripción
*OperacionesCoDiApi* | [**consult_codi_operations**](docs/OperacionesCoDiApi.md#consult_codi_operations) | **POST** /codi/charges | Consulta de operaciones
*PeticionesDePagoPorCoDiApi* | [**consult_codi_request_by_order_id**](docs/PeticionesDePagoPorCoDiApi.md#consult_codi_request_by_order_id) | **GET** /codi/sales-point/charges | Consulta información de petición por orderId
*PeticionesDePagoPorCoDiApi* | [**generate_codi_code_qr**](docs/PeticionesDePagoPorCoDiApi.md#generate_codi_code_qr) | **POST** /codi/sales-point/charges | Genera código QR
*PuntosDeVentaCoDiApi* | [**create_sales_point**](docs/PuntosDeVentaCoDiApi.md#create_sales_point) | **POST** /codi/companies/salespoint | Registro de punto de venta.
*PuntosDeVentaCoDiApi* | [**obtain_sale_points**](docs/PuntosDeVentaCoDiApi.md#obtain_sale_points) | **GET** /codi/companies/salespoint | Consulta de puntos de venta
*SaldoApi* | [**get_balance_using_get**](docs/SaldoApi.md#get_balance_using_get) | **GET** /subscriptions/{subscription}/balance | Consulta los saldo de una cuenta
*SuscripcionesApi* | [**change_subscription_status_using_put**](docs/SuscripcionesApi.md#change_subscription_status_using_put) | **PUT** /subscriptions/{subscription}/status | Cambia el estatus de la suscripción
*SuscripcionesApi* | [**change_subscription_use_using_patch**](docs/SuscripcionesApi.md#change_subscription_use_using_patch) | **PATCH** /subscriptions/{subscription} | Cambia el uso de la suscripción
*SuscripcionesApi* | [**pre_enrollment_monex_user_using_post**](docs/SuscripcionesApi.md#pre_enrollment_monex_user_using_post) | **POST** /subscriptions/pre-subscription | Pre-registro de una suscripción
*SuscripcionesApi* | [**remove_enrollment_user_using_delete**](docs/SuscripcionesApi.md#remove_enrollment_user_using_delete) | **DELETE** /subscriptions/{subscription} | Elimina suscripción por su identificador.
*SuscripcionesApi* | [**remove_subscription_pending_status_using_delete**](docs/SuscripcionesApi.md#remove_subscription_pending_status_using_delete) | **DELETE** /subscriptions/pre-subscription/{subscription} | Elimina pre-registro de suscripción
*TransferenciasSPEIApi* | [**create_authorization_transactions_group**](docs/TransferenciasSPEIApi.md#create_authorization_transactions_group) | **POST** /subscriptions/{subscription}/transactions/group | Agrupa transacciones bajo un request_id 
*TransferenciasSPEIApi* | [**drop_transactions_pending_using_delete**](docs/TransferenciasSPEIApi.md#drop_transactions_pending_using_delete) | **DELETE** /subscriptions/{subscription}/transactions/outcoming/spei/request/{requestId} | Eliminación de transferencias SPEI® pendientes
*TransferenciasSPEIApi* | [**incoming_spei_transactions_report_using_get**](docs/TransferenciasSPEIApi.md#incoming_spei_transactions_report_using_get) | **GET** /subscriptions/{subscription}/transactions/incoming/spei | Consulta de transferencias recibidas
*TransferenciasSPEIApi* | [**out_comming_spei_request_id_transactions_report_using_get**](docs/TransferenciasSPEIApi.md#out_comming_spei_request_id_transactions_report_using_get) | **GET** /subscriptions/{subscription}/transactions/outcoming/spei/{requestId} | Consulta de transferencias de salida por identificador de petición
*TransferenciasSPEIApi* | [**outgoing_spei_transactions_report_using_get**](docs/TransferenciasSPEIApi.md#outgoing_spei_transactions_report_using_get) | **GET** /subscriptions/{subscription}/transactions/outcoming/spei | Consulta de transferencias realizadas
*TransferenciasSPEIApi* | [**register_outgoing_spei_transaction_using_post**](docs/TransferenciasSPEIApi.md#register_outgoing_spei_transaction_using_post) | **POST** /subscriptions/{subscription}/transactions/outcoming/spei | Registro de transferencias
*TransferenciasSPIDApi* | [**get_spid_classifications_using_get**](docs/TransferenciasSPIDApi.md#get_spid_classifications_using_get) | **GET** /subscriptions/{subscription}/beneficiaries/spid/classifications | Consulta de clasificaciones para operaciones SPID®
*TransferenciasSPIDApi* | [**register_outgoing_spid_transaction_using_post**](docs/TransferenciasSPIDApi.md#register_outgoing_spid_transaction_using_post) | **POST** /subscriptions/{subscription}/transactions/outcoming/spid | Registro de transferencias SPID®
*WebhooksApi* | [**get_webhook**](docs/WebhooksApi.md#get_webhook) | **GET** /webhooks/{webhook_id} | Consulta de Webhook
*WebhooksApi* | [**get_webhooks**](docs/WebhooksApi.md#get_webhooks) | **GET** /webhooks | Consulta la lista de Webhooks
*WebhooksApi* | [**register_webhook**](docs/WebhooksApi.md#register_webhook) | **POST** /webhooks | Alta de Webhook

## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountDetail](docs/AccountDetail.md)
 - [AccountReassigned](docs/AccountReassigned.md)
 - [AccountRequest](docs/AccountRequest.md)
 - [AccountResponse](docs/AccountResponse.md)
 - [AccountSpid](docs/AccountSpid.md)
 - [AddressCompany](docs/AddressCompany.md)
 - [AmountRequest](docs/AmountRequest.md)
 - [AuthorizationTransactionGroup](docs/AuthorizationTransactionGroup.md)
 - [AuthorizedBeneficiariesResponse](docs/AuthorizedBeneficiariesResponse.md)
 - [AuthorizedUsers](docs/AuthorizedUsers.md)
 - [Balance](docs/Balance.md)
 - [BalanceListResponse](docs/BalanceListResponse.md)
 - [BeneficiariesQueryRegisterStatus](docs/BeneficiariesQueryRegisterStatus.md)
 - [BeneficiariesResponse](docs/BeneficiariesResponse.md)
 - [BeneficiaryInstitution](docs/BeneficiaryInstitution.md)
 - [Billing](docs/Billing.md)
 - [BillingTransaction](docs/BillingTransaction.md)
 - [CepResponse](docs/CepResponse.md)
 - [CepSearchBanxico](docs/CepSearchBanxico.md)
 - [CertificateRequest](docs/CertificateRequest.md)
 - [CodiCodeQrResponseDTO](docs/CodiCodeQrResponseDTO.md)
 - [CodiCodeRequestDTO](docs/CodiCodeRequestDTO.md)
 - [CodiOperationResponseDTO](docs/CodiOperationResponseDTO.md)
 - [CodiOperationsFiltersRequestDTO](docs/CodiOperationsFiltersRequestDTO.md)
 - [CompanyRegistered](docs/CompanyRegistered.md)
 - [CompanyRequested](docs/CompanyRequested.md)
 - [Compay](docs/Compay.md)
 - [ConfigurationsLimits](docs/ConfigurationsLimits.md)
 - [ContactRequest](docs/ContactRequest.md)
 - [ContractDetailRequest](docs/ContractDetailRequest.md)
 - [ContractDetailResponse](docs/ContractDetailResponse.md)
 - [Deposit](docs/Deposit.md)
 - [DepositAuthorizationRequest](docs/DepositAuthorizationRequest.md)
 - [Depositant](docs/Depositant.md)
 - [DepositantsRegister](docs/DepositantsRegister.md)
 - [DepositantsResponse](docs/DepositantsResponse.md)
 - [DepositsAuthorizationResponse](docs/DepositsAuthorizationResponse.md)
 - [DetailedErrorResponse](docs/DetailedErrorResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [GetDepositants](docs/GetDepositants.md)
 - [Institution](docs/Institution.md)
 - [InstitutionsList](docs/InstitutionsList.md)
 - [Item](docs/Item.md)
 - [MessageAccountBeneficiary](docs/MessageAccountBeneficiary.md)
 - [MessageCEP](docs/MessageCEP.md)
 - [MessageCodiAction](docs/MessageCodiAction.md)
 - [MessageConfigurationsLimits](docs/MessageConfigurationsLimits.md)
 - [MessageDepositAuthorizationRequest](docs/MessageDepositAuthorizationRequest.md)
 - [MessageDepositReceived](docs/MessageDepositReceived.md)
 - [MessageInstitution](docs/MessageInstitution.md)
 - [MessagePayment](docs/MessagePayment.md)
 - [MessagePaymentStatePending](docs/MessagePaymentStatePending.md)
 - [MessageRequestChanged](docs/MessageRequestChanged.md)
 - [MessageSalesPoint](docs/MessageSalesPoint.md)
 - [MessageSubscription](docs/MessageSubscription.md)
 - [MessageUserAuthorized](docs/MessageUserAuthorized.md)
 - [MessageWebHook](docs/MessageWebHook.md)
 - [Operations](docs/Operations.md)
 - [PagerResponseDto](docs/PagerResponseDto.md)
 - [Payment](docs/Payment.md)
 - [PaymentCODI](docs/PaymentCODI.md)
 - [PaymentRequestCodiResponseDTO](docs/PaymentRequestCodiResponseDTO.md)
 - [PaymentsRequestId](docs/PaymentsRequestId.md)
 - [Person](docs/Person.md)
 - [PreEnrollmentData](docs/PreEnrollmentData.md)
 - [PreEnrollmentResponse](docs/PreEnrollmentResponse.md)
 - [PreMonexAuthorization](docs/PreMonexAuthorization.md)
 - [Relationship](docs/Relationship.md)
 - [RelationshipsResponse](docs/RelationshipsResponse.md)
 - [SalesPoint](docs/SalesPoint.md)
 - [SalesPointFound](docs/SalesPointFound.md)
 - [SalesPointRequest](docs/SalesPointRequest.md)
 - [SalesPointRespose](docs/SalesPointRespose.md)
 - [ServiceBanking](docs/ServiceBanking.md)
 - [SpidBeneficiariesResponse](docs/SpidBeneficiariesResponse.md)
 - [SpidBeneficiaryResponse](docs/SpidBeneficiaryResponse.md)
 - [SpidClassificationDTO](docs/SpidClassificationDTO.md)
 - [SpidClassificationsResponseDTO](docs/SpidClassificationsResponseDTO.md)
 - [SubscriptionChangeStatusRequest](docs/SubscriptionChangeStatusRequest.md)
 - [TokenRequiredResponse](docs/TokenRequiredResponse.md)
 - [TransactionErrorCode](docs/TransactionErrorCode.md)
 - [TransactionOutgoing](docs/TransactionOutgoing.md)
 - [TransactionOutgoingSpid](docs/TransactionOutgoingSpid.md)
 - [TransactionsOutgoingRegister](docs/TransactionsOutgoingRegister.md)
 - [UpdateConfigurationsRequestDTO](docs/UpdateConfigurationsRequestDTO.md)
 - [UrlsRedirect](docs/UrlsRedirect.md)
 - [UseServiceBanking](docs/UseServiceBanking.md)
 - [UserCompany](docs/UserCompany.md)
 - [WebHookDepositAuthorizationRequest](docs/WebHookDepositAuthorizationRequest.md)
 - [WebHookDepositAuthorizationResponse](docs/WebHookDepositAuthorizationResponse.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookRequest](docs/WebhookRequest.md)
 - [WebhookResponse](docs/WebhookResponse.md)
 - [WebhooksList](docs/WebhooksList.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


