# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wire4_client.api_client import ApiClient


class CuentasDeBeneficiariosSPIDApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_spid_beneficiaries_for_account(self, authorization, subscription, **kwargs):  # noqa: E501
        """Consulta los beneficiarios SPID registrados  # noqa: E501

        Obtiene los beneficiarios SPID registrados al contrato relacionado con la suscripción. Los beneficiarios son los que actualmente se encuentran registrados en banca Monex.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_spid_beneficiaries_for_account(authorization, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: Header para token (required)
        :param str subscription: Es el identificador de la suscripción a esta API. (required)
        :param str account: Cuenta del beneficiario, puede ser CLABE (18 dígitos), Tarjeta de débito  (TDD, 16 dígitos) o número de celular (10 dígitos).
        :param str beneficiary_bank: Es la clave del banco beneficiario. Se puede obtener del catalogo de <a href=\"#operation/getAllInstitutionsUsingGET\">instituciones.</a>
        :param str beneficiary_name: Es el nombre del beneficiario.
        :param str end_date: Es la fecha de inicio del periodo a filtrar en formato dd-mm-yyyy.
        :param str init_date: Es la fecha de inicio del periodo a filtrar en formato dd-mm-yyyy.
        :param str rfc: Es el Registro Federal de Contribuyentes (RFC) del beneficiario.
        :param str status: Es el estado (estatus) de la cuenta, Los valores pueden ser <b>PENDING</b> y <b>REGISTERED</b>.
        :return: SpidBeneficiariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_spid_beneficiaries_for_account_with_http_info(authorization, subscription, **kwargs)  # noqa: E501
        else:
            (data) = self.get_spid_beneficiaries_for_account_with_http_info(authorization, subscription, **kwargs)  # noqa: E501
            return data

    def get_spid_beneficiaries_for_account_with_http_info(self, authorization, subscription, **kwargs):  # noqa: E501
        """Consulta los beneficiarios SPID registrados  # noqa: E501

        Obtiene los beneficiarios SPID registrados al contrato relacionado con la suscripción. Los beneficiarios son los que actualmente se encuentran registrados en banca Monex.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_spid_beneficiaries_for_account_with_http_info(authorization, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: Header para token (required)
        :param str subscription: Es el identificador de la suscripción a esta API. (required)
        :param str account: Cuenta del beneficiario, puede ser CLABE (18 dígitos), Tarjeta de débito  (TDD, 16 dígitos) o número de celular (10 dígitos).
        :param str beneficiary_bank: Es la clave del banco beneficiario. Se puede obtener del catalogo de <a href=\"#operation/getAllInstitutionsUsingGET\">instituciones.</a>
        :param str beneficiary_name: Es el nombre del beneficiario.
        :param str end_date: Es la fecha de inicio del periodo a filtrar en formato dd-mm-yyyy.
        :param str init_date: Es la fecha de inicio del periodo a filtrar en formato dd-mm-yyyy.
        :param str rfc: Es el Registro Federal de Contribuyentes (RFC) del beneficiario.
        :param str status: Es el estado (estatus) de la cuenta, Los valores pueden ser <b>PENDING</b> y <b>REGISTERED</b>.
        :return: SpidBeneficiariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'subscription', 'account', 'beneficiary_bank', 'beneficiary_name', 'end_date', 'init_date', 'rfc', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_spid_beneficiaries_for_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `get_spid_beneficiaries_for_account`")  # noqa: E501
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params or
                params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `get_spid_beneficiaries_for_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription' in params:
            path_params['subscription'] = params['subscription']  # noqa: E501

        query_params = []
        if 'account' in params:
            query_params.append(('account', params['account']))  # noqa: E501
        if 'beneficiary_bank' in params:
            query_params.append(('beneficiary_bank', params['beneficiary_bank']))  # noqa: E501
        if 'beneficiary_name' in params:
            query_params.append(('beneficiary_name', params['beneficiary_name']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'init_date' in params:
            query_params.append(('init_date', params['init_date']))  # noqa: E501
        if 'rfc' in params:
            query_params.append(('rfc', params['rfc']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscription}/beneficiaries/spid', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SpidBeneficiariesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pre_register_accounts_using_post1(self, body, authorization, subscription, **kwargs):  # noqa: E501
        """Pre-registro de cuentas de beneficiarios SPID®  # noqa: E501

        Pre-registra una o más cuentas de beneficiario SPID® en la plataforma de Wire4, ésta le proporcionaará una URL donde lo llevará al centro de autorización para que el cuentahabiente Monex ingrese su llave digital para confirmar el alta de las cuentas de beneficiarios.<br/> Los posibles valores de <em>relationship</em> y <em>kind_of_relationship</em> se deben  obtener de <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">/subscriptions/{subscription}/beneficiaries/relationships.</a><br/><br/>La confirmación de registro en Monex se realizará a través de una notificación a los webhooks registrados con el evento de tipo <a href=\"#section/Eventos/Tipos-de-Eventos\">ACCOUNT.CREATED.</a>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pre_register_accounts_using_post1(body, authorization, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountSpid body: Información de la cuenta del beneficiario (required)
        :param str authorization: Header para token (required)
        :param str subscription: Es el identificador de la suscripción a esta API. (required)
        :return: TokenRequiredResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pre_register_accounts_using_post1_with_http_info(body, authorization, subscription, **kwargs)  # noqa: E501
        else:
            (data) = self.pre_register_accounts_using_post1_with_http_info(body, authorization, subscription, **kwargs)  # noqa: E501
            return data

    def pre_register_accounts_using_post1_with_http_info(self, body, authorization, subscription, **kwargs):  # noqa: E501
        """Pre-registro de cuentas de beneficiarios SPID®  # noqa: E501

        Pre-registra una o más cuentas de beneficiario SPID® en la plataforma de Wire4, ésta le proporcionaará una URL donde lo llevará al centro de autorización para que el cuentahabiente Monex ingrese su llave digital para confirmar el alta de las cuentas de beneficiarios.<br/> Los posibles valores de <em>relationship</em> y <em>kind_of_relationship</em> se deben  obtener de <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">/subscriptions/{subscription}/beneficiaries/relationships.</a><br/><br/>La confirmación de registro en Monex se realizará a través de una notificación a los webhooks registrados con el evento de tipo <a href=\"#section/Eventos/Tipos-de-Eventos\">ACCOUNT.CREATED.</a>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pre_register_accounts_using_post1_with_http_info(body, authorization, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountSpid body: Información de la cuenta del beneficiario (required)
        :param str authorization: Header para token (required)
        :param str subscription: Es el identificador de la suscripción a esta API. (required)
        :return: TokenRequiredResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'authorization', 'subscription']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pre_register_accounts_using_post1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `pre_register_accounts_using_post1`")  # noqa: E501
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `pre_register_accounts_using_post1`")  # noqa: E501
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params or
                params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `pre_register_accounts_using_post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription' in params:
            path_params['subscription'] = params['subscription']  # noqa: E501

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscription}/beneficiaries/spid', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenRequiredResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
