# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wire4_client.api_client import ApiClient


class OperacionesCoDiApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def consult_codi_operations(self, authorization, **kwargs):  # noqa: E501
        """Consulta de operaciones  # noqa: E501

        Obtiene las operaciones generadas a partir de peticiones de pago CODI® de forma paginada, pudiendo aplicar filtros.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.consult_codi_operations(authorization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: Header para token (required)
        :param CodiOperationsFiltersRequestDTO body: Filtros de busqueda
        :param str company_id: Es el identificador de empresa CODI®.
        :param str page: Es el número de pago.
        :param str sales_point_id: Es el identificador del punto de venta.
        :param str size: Es el tamaño de página.
        :return: PagerResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.consult_codi_operations_with_http_info(authorization, **kwargs)  # noqa: E501
        else:
            (data) = self.consult_codi_operations_with_http_info(authorization, **kwargs)  # noqa: E501
            return data

    def consult_codi_operations_with_http_info(self, authorization, **kwargs):  # noqa: E501
        """Consulta de operaciones  # noqa: E501

        Obtiene las operaciones generadas a partir de peticiones de pago CODI® de forma paginada, pudiendo aplicar filtros.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.consult_codi_operations_with_http_info(authorization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: Header para token (required)
        :param CodiOperationsFiltersRequestDTO body: Filtros de busqueda
        :param str company_id: Es el identificador de empresa CODI®.
        :param str page: Es el número de pago.
        :param str sales_point_id: Es el identificador del punto de venta.
        :param str size: Es el tamaño de página.
        :return: PagerResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'body', 'company_id', 'page', 'sales_point_id', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method consult_codi_operations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `consult_codi_operations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'company_id' in params:
            query_params.append(('company_id', params['company_id']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sales_point_id' in params:
            query_params.append(('sales_point_id', params['sales_point_id']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/codi/charges', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagerResponseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
