# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wire4_client.api_client import ApiClient


class PuntosDeVentaCoDiApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_sales_point(self, body, authorization, company_id, **kwargs):  # noqa: E501
        """Registro de punto de venta.  # noqa: E501

        Se registra un punto de venta (TPV) desde donde se emitarán los cobros CODI®. El punto de venta se debe asociar a un cuenta CLABE registrada previamente ante Banxico para realizar cobros con CODI®.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sales_point(body, authorization, company_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SalesPointRequest body: Es el objeto que contiene información del punto de venta CODI®. (required)
        :param str authorization: Header para token (required)
        :param str company_id: Es el identificador de la empresa. (required)
        :return: SalesPointRespose
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sales_point_with_http_info(body, authorization, company_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sales_point_with_http_info(body, authorization, company_id, **kwargs)  # noqa: E501
            return data

    def create_sales_point_with_http_info(self, body, authorization, company_id, **kwargs):  # noqa: E501
        """Registro de punto de venta.  # noqa: E501

        Se registra un punto de venta (TPV) desde donde se emitarán los cobros CODI®. El punto de venta se debe asociar a un cuenta CLABE registrada previamente ante Banxico para realizar cobros con CODI®.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sales_point_with_http_info(body, authorization, company_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SalesPointRequest body: Es el objeto que contiene información del punto de venta CODI®. (required)
        :param str authorization: Header para token (required)
        :param str company_id: Es el identificador de la empresa. (required)
        :return: SalesPointRespose
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'authorization', 'company_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sales_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_sales_point`")  # noqa: E501
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `create_sales_point`")  # noqa: E501
        # verify the required parameter 'company_id' is set
        if ('company_id' not in params or
                params['company_id'] is None):
            raise ValueError("Missing the required parameter `company_id` when calling `create_sales_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'company_id' in params:
            query_params.append(('companyId', params['company_id']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/codi/companies/salespoint', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SalesPointRespose',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def obtain_sale_points(self, authorization, company_id, **kwargs):  # noqa: E501
        """Consulta de puntos de venta  # noqa: E501

        Obtiene los puntos de venta asociados a una empresa en las cuales se hacen operaciones CODI®.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.obtain_sale_points(authorization, company_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: Header para token (required)
        :param str company_id: Es el identificador de la empresa. Ejemplo: 8838d513-5916-4662-bb30-2448f0f543ed (required)
        :return: list[SalesPointFound]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.obtain_sale_points_with_http_info(authorization, company_id, **kwargs)  # noqa: E501
        else:
            (data) = self.obtain_sale_points_with_http_info(authorization, company_id, **kwargs)  # noqa: E501
            return data

    def obtain_sale_points_with_http_info(self, authorization, company_id, **kwargs):  # noqa: E501
        """Consulta de puntos de venta  # noqa: E501

        Obtiene los puntos de venta asociados a una empresa en las cuales se hacen operaciones CODI®.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.obtain_sale_points_with_http_info(authorization, company_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: Header para token (required)
        :param str company_id: Es el identificador de la empresa. Ejemplo: 8838d513-5916-4662-bb30-2448f0f543ed (required)
        :return: list[SalesPointFound]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'company_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method obtain_sale_points" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `obtain_sale_points`")  # noqa: E501
        # verify the required parameter 'company_id' is set
        if ('company_id' not in params or
                params['company_id'] is None):
            raise ValueError("Missing the required parameter `company_id` when calling `obtain_sale_points`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'company_id' in params:
            query_params.append(('companyId', params['company_id']))  # noqa: E501

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/codi/companies/salespoint', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SalesPointFound]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
