# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from wire4_client.models.beneficiary_institution import BeneficiaryInstitution  # noqa: F401,E501
from wire4_client.models.institution import Institution  # noqa: F401,E501
from wire4_client.models.person import Person  # noqa: F401,E501


class AccountReassigned(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount_limit': 'float',
        'bank': 'Institution',
        'beneficiary_account': 'str',
        'currency_code': 'str',
        'email': 'list[str]',
        'institution': 'BeneficiaryInstitution',
        'kind_of_relationship': 'str',
        'numeric_reference_spei': 'str',
        'payment_concept_spei': 'str',
        'person': 'Person',
        'register_date': 'datetime',
        'relationship': 'str',
        'rfc': 'str',
        'status': 'str'
    }

    attribute_map = {
        'amount_limit': 'amount_limit',
        'bank': 'bank',
        'beneficiary_account': 'beneficiary_account',
        'currency_code': 'currency_code',
        'email': 'email',
        'institution': 'institution',
        'kind_of_relationship': 'kind_of_relationship',
        'numeric_reference_spei': 'numeric_reference_spei',
        'payment_concept_spei': 'payment_concept_spei',
        'person': 'person',
        'register_date': 'register_date',
        'relationship': 'relationship',
        'rfc': 'rfc',
        'status': 'status'
    }

    def __init__(self, amount_limit=None, bank=None, beneficiary_account=None, currency_code=None, email=None, institution=None, kind_of_relationship=None, numeric_reference_spei=None, payment_concept_spei=None, person=None, register_date=None, relationship=None, rfc=None, status=None):  # noqa: E501
        """AccountReassigned - a model defined in Swagger"""  # noqa: E501
        self._amount_limit = None
        self._bank = None
        self._beneficiary_account = None
        self._currency_code = None
        self._email = None
        self._institution = None
        self._kind_of_relationship = None
        self._numeric_reference_spei = None
        self._payment_concept_spei = None
        self._person = None
        self._register_date = None
        self._relationship = None
        self._rfc = None
        self._status = None
        self.discriminator = None
        self.amount_limit = amount_limit
        if bank is not None:
            self.bank = bank
        self.beneficiary_account = beneficiary_account
        if currency_code is not None:
            self.currency_code = currency_code
        if email is not None:
            self.email = email
        if institution is not None:
            self.institution = institution
        self.kind_of_relationship = kind_of_relationship
        if numeric_reference_spei is not None:
            self.numeric_reference_spei = numeric_reference_spei
        if payment_concept_spei is not None:
            self.payment_concept_spei = payment_concept_spei
        if person is not None:
            self.person = person
        if register_date is not None:
            self.register_date = register_date
        self.relationship = relationship
        self.rfc = rfc
        if status is not None:
            self.status = status

    @property
    def amount_limit(self):
        """Gets the amount_limit of this AccountReassigned.  # noqa: E501

        Es el monto límite permitido que se registra para la cuenta. Por ejemplo 1000.00.  # noqa: E501

        :return: The amount_limit of this AccountReassigned.  # noqa: E501
        :rtype: float
        """
        return self._amount_limit

    @amount_limit.setter
    def amount_limit(self, amount_limit):
        """Sets the amount_limit of this AccountReassigned.

        Es el monto límite permitido que se registra para la cuenta. Por ejemplo 1000.00.  # noqa: E501

        :param amount_limit: The amount_limit of this AccountReassigned.  # noqa: E501
        :type: float
        """
        if amount_limit is None:
            raise ValueError("Invalid value for `amount_limit`, must not be `None`")  # noqa: E501

        self._amount_limit = amount_limit

    @property
    def bank(self):
        """Gets the bank of this AccountReassigned.  # noqa: E501


        :return: The bank of this AccountReassigned.  # noqa: E501
        :rtype: Institution
        """
        return self._bank

    @bank.setter
    def bank(self, bank):
        """Sets the bank of this AccountReassigned.


        :param bank: The bank of this AccountReassigned.  # noqa: E501
        :type: Institution
        """

        self._bank = bank

    @property
    def beneficiary_account(self):
        """Gets the beneficiary_account of this AccountReassigned.  # noqa: E501

        Es la cuenta del beneficiario, podría ser teléfono celular (se valida que sea de 10 dígitos), Tarjeta de débito (TDD, se valida que sea de 16 dígitos) o cuenta CLABE (se valida que sea de 18 dígitos). <br/><br/>Por ejemplo Teléfono celular: 5525072600, TDD: 4323 1234 5678 9123, CLABE: 032180000118359719.  # noqa: E501

        :return: The beneficiary_account of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._beneficiary_account

    @beneficiary_account.setter
    def beneficiary_account(self, beneficiary_account):
        """Sets the beneficiary_account of this AccountReassigned.

        Es la cuenta del beneficiario, podría ser teléfono celular (se valida que sea de 10 dígitos), Tarjeta de débito (TDD, se valida que sea de 16 dígitos) o cuenta CLABE (se valida que sea de 18 dígitos). <br/><br/>Por ejemplo Teléfono celular: 5525072600, TDD: 4323 1234 5678 9123, CLABE: 032180000118359719.  # noqa: E501

        :param beneficiary_account: The beneficiary_account of this AccountReassigned.  # noqa: E501
        :type: str
        """
        if beneficiary_account is None:
            raise ValueError("Invalid value for `beneficiary_account`, must not be `None`")  # noqa: E501

        self._beneficiary_account = beneficiary_account

    @property
    def currency_code(self):
        """Gets the currency_code of this AccountReassigned.  # noqa: E501

        Es el código de divisa. Es en el formato estándar de 3 dígitos, por ejemplo para el peso mexicano: <b>MXP</b>, para el dólar estadounidense: <b>USD</b>.<br/><br/>Este dato es opcional, al registrar una cuenta si no se cuenta con este valor se asignará <b>MXP</b>  # noqa: E501

        :return: The currency_code of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this AccountReassigned.

        Es el código de divisa. Es en el formato estándar de 3 dígitos, por ejemplo para el peso mexicano: <b>MXP</b>, para el dólar estadounidense: <b>USD</b>.<br/><br/>Este dato es opcional, al registrar una cuenta si no se cuenta con este valor se asignará <b>MXP</b>  # noqa: E501

        :param currency_code: The currency_code of this AccountReassigned.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def email(self):
        """Gets the email of this AccountReassigned.  # noqa: E501

        Es una lista de correos electrónicos (emails). Se valida el formato de email. Este campo es opcional.  # noqa: E501

        :return: The email of this AccountReassigned.  # noqa: E501
        :rtype: list[str]
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this AccountReassigned.

        Es una lista de correos electrónicos (emails). Se valida el formato de email. Este campo es opcional.  # noqa: E501

        :param email: The email of this AccountReassigned.  # noqa: E501
        :type: list[str]
        """

        self._email = email

    @property
    def institution(self):
        """Gets the institution of this AccountReassigned.  # noqa: E501


        :return: The institution of this AccountReassigned.  # noqa: E501
        :rtype: BeneficiaryInstitution
        """
        return self._institution

    @institution.setter
    def institution(self, institution):
        """Sets the institution of this AccountReassigned.


        :param institution: The institution of this AccountReassigned.  # noqa: E501
        :type: BeneficiaryInstitution
        """

        self._institution = institution

    @property
    def kind_of_relationship(self):
        """Gets the kind_of_relationship of this AccountReassigned.  # noqa: E501

        Es el tipo de relación que se tiene con el propietario de la cuenta. Para registrar una cuenta, este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">relationships.</a> <br /><br /><b>Nota:</b> <em>Si en la respuesta de Monex esta propiedad es nula, tampoco estará presente en esta respuesta.</em>  # noqa: E501

        :return: The kind_of_relationship of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._kind_of_relationship

    @kind_of_relationship.setter
    def kind_of_relationship(self, kind_of_relationship):
        """Sets the kind_of_relationship of this AccountReassigned.

        Es el tipo de relación que se tiene con el propietario de la cuenta. Para registrar una cuenta, este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">relationships.</a> <br /><br /><b>Nota:</b> <em>Si en la respuesta de Monex esta propiedad es nula, tampoco estará presente en esta respuesta.</em>  # noqa: E501

        :param kind_of_relationship: The kind_of_relationship of this AccountReassigned.  # noqa: E501
        :type: str
        """
        if kind_of_relationship is None:
            raise ValueError("Invalid value for `kind_of_relationship`, must not be `None`")  # noqa: E501

        self._kind_of_relationship = kind_of_relationship

    @property
    def numeric_reference_spei(self):
        """Gets the numeric_reference_spei of this AccountReassigned.  # noqa: E501

        Es la referencia numérica a utilizar cuando se realice una transferencia y no se especifique una referencia.  # noqa: E501

        :return: The numeric_reference_spei of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._numeric_reference_spei

    @numeric_reference_spei.setter
    def numeric_reference_spei(self, numeric_reference_spei):
        """Sets the numeric_reference_spei of this AccountReassigned.

        Es la referencia numérica a utilizar cuando se realice una transferencia y no se especifique una referencia.  # noqa: E501

        :param numeric_reference_spei: The numeric_reference_spei of this AccountReassigned.  # noqa: E501
        :type: str
        """

        self._numeric_reference_spei = numeric_reference_spei

    @property
    def payment_concept_spei(self):
        """Gets the payment_concept_spei of this AccountReassigned.  # noqa: E501

        Es el concepto de pago a utilizar cuando se realice una transferencia y no se especifique un concepto  # noqa: E501

        :return: The payment_concept_spei of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._payment_concept_spei

    @payment_concept_spei.setter
    def payment_concept_spei(self, payment_concept_spei):
        """Sets the payment_concept_spei of this AccountReassigned.

        Es el concepto de pago a utilizar cuando se realice una transferencia y no se especifique un concepto  # noqa: E501

        :param payment_concept_spei: The payment_concept_spei of this AccountReassigned.  # noqa: E501
        :type: str
        """

        self._payment_concept_spei = payment_concept_spei

    @property
    def person(self):
        """Gets the person of this AccountReassigned.  # noqa: E501


        :return: The person of this AccountReassigned.  # noqa: E501
        :rtype: Person
        """
        return self._person

    @person.setter
    def person(self, person):
        """Sets the person of this AccountReassigned.


        :param person: The person of this AccountReassigned.  # noqa: E501
        :type: Person
        """

        self._person = person

    @property
    def register_date(self):
        """Gets the register_date of this AccountReassigned.  # noqa: E501

        Es la fecha en la que se registró el beneficiario. Ésta fecha viene en formato ISO 8601 con zona horaria, ejemplo: <strong>2020-10-27T11:03:15.000-06:00</strong>.  # noqa: E501

        :return: The register_date of this AccountReassigned.  # noqa: E501
        :rtype: datetime
        """
        return self._register_date

    @register_date.setter
    def register_date(self, register_date):
        """Sets the register_date of this AccountReassigned.

        Es la fecha en la que se registró el beneficiario. Ésta fecha viene en formato ISO 8601 con zona horaria, ejemplo: <strong>2020-10-27T11:03:15.000-06:00</strong>.  # noqa: E501

        :param register_date: The register_date of this AccountReassigned.  # noqa: E501
        :type: datetime
        """

        self._register_date = register_date

    @property
    def relationship(self):
        """Gets the relationship of this AccountReassigned.  # noqa: E501

        Es la relación con el propietario de la cuenta, para registrar este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">relationships.</a> <br/> <br/> <b>Nota:</b> Si en la respuesta de Monex, sta propiedad es nula, tampoco estará presente en esta respuesta.  # noqa: E501

        :return: The relationship of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._relationship

    @relationship.setter
    def relationship(self, relationship):
        """Sets the relationship of this AccountReassigned.

        Es la relación con el propietario de la cuenta, para registrar este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">relationships.</a> <br/> <br/> <b>Nota:</b> Si en la respuesta de Monex, sta propiedad es nula, tampoco estará presente en esta respuesta.  # noqa: E501

        :param relationship: The relationship of this AccountReassigned.  # noqa: E501
        :type: str
        """
        if relationship is None:
            raise ValueError("Invalid value for `relationship`, must not be `None`")  # noqa: E501

        self._relationship = relationship

    @property
    def rfc(self):
        """Gets the rfc of this AccountReassigned.  # noqa: E501

        Es el Registro Federal de Contribuyentes (RFC) de la persona o institución propietaria dela cuenta. <br/> <br/><b>Nota:</b> Si en la respuesta de Monex esta propiedad es nula, tampoco estará presente en esta respuesta.  # noqa: E501

        :return: The rfc of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._rfc

    @rfc.setter
    def rfc(self, rfc):
        """Sets the rfc of this AccountReassigned.

        Es el Registro Federal de Contribuyentes (RFC) de la persona o institución propietaria dela cuenta. <br/> <br/><b>Nota:</b> Si en la respuesta de Monex esta propiedad es nula, tampoco estará presente en esta respuesta.  # noqa: E501

        :param rfc: The rfc of this AccountReassigned.  # noqa: E501
        :type: str
        """
        if rfc is None:
            raise ValueError("Invalid value for `rfc`, must not be `None`")  # noqa: E501

        self._rfc = rfc

    @property
    def status(self):
        """Gets the status of this AccountReassigned.  # noqa: E501

        Es el estado en el que se encuentra el registo del beneficiario.<br>Los valores pueden ser:<ul style=\"font-size: 12px; font-weight: 600;\"><li>RECEIVED</li><li>DELETED</li><li>REQUEST_ERROR_BY_MONEX</li><li>REQUESTED_TO_MONEX</li><li>NOTIFIED_BY_MONEX</li><li>NOTIFIED_BY_SPEIOK<li></li>NOTIFIED_WITH_ERROR_BY_SPEIOK</li><li>PENDING</li></ul>  # noqa: E501

        :return: The status of this AccountReassigned.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this AccountReassigned.

        Es el estado en el que se encuentra el registo del beneficiario.<br>Los valores pueden ser:<ul style=\"font-size: 12px; font-weight: 600;\"><li>RECEIVED</li><li>DELETED</li><li>REQUEST_ERROR_BY_MONEX</li><li>REQUESTED_TO_MONEX</li><li>NOTIFIED_BY_MONEX</li><li>NOTIFIED_BY_SPEIOK<li></li>NOTIFIED_WITH_ERROR_BY_SPEIOK</li><li>PENDING</li></ul>  # noqa: E501

        :param status: The status of this AccountReassigned.  # noqa: E501
        :type: str
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccountReassigned, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountReassigned):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
