# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from wire4_client.models.beneficiary_institution import BeneficiaryInstitution  # noqa: F401,E501


class AccountSpid(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount_limit': 'float',
        'bank_code_banxico': 'str',
        'beneficiary_account': 'str',
        'cancel_return_url': 'str',
        'email': 'list[str]',
        'institution': 'BeneficiaryInstitution',
        'kind_of_relationship': 'str',
        'numeric_reference': 'str',
        'payment_concept': 'str',
        'relationship': 'str',
        'return_url': 'str',
        'rfc': 'str'
    }

    attribute_map = {
        'amount_limit': 'amount_limit',
        'bank_code_banxico': 'bank_code_banxico',
        'beneficiary_account': 'beneficiary_account',
        'cancel_return_url': 'cancel_return_url',
        'email': 'email',
        'institution': 'institution',
        'kind_of_relationship': 'kind_of_relationship',
        'numeric_reference': 'numeric_reference',
        'payment_concept': 'payment_concept',
        'relationship': 'relationship',
        'return_url': 'return_url',
        'rfc': 'rfc'
    }

    def __init__(self, amount_limit=None, bank_code_banxico=None, beneficiary_account=None, cancel_return_url=None, email=None, institution=None, kind_of_relationship=None, numeric_reference=None, payment_concept=None, relationship=None, return_url=None, rfc=None):  # noqa: E501
        """AccountSpid - a model defined in Swagger"""  # noqa: E501
        self._amount_limit = None
        self._bank_code_banxico = None
        self._beneficiary_account = None
        self._cancel_return_url = None
        self._email = None
        self._institution = None
        self._kind_of_relationship = None
        self._numeric_reference = None
        self._payment_concept = None
        self._relationship = None
        self._return_url = None
        self._rfc = None
        self.discriminator = None
        self.amount_limit = amount_limit
        if bank_code_banxico is not None:
            self.bank_code_banxico = bank_code_banxico
        self.beneficiary_account = beneficiary_account
        if cancel_return_url is not None:
            self.cancel_return_url = cancel_return_url
        if email is not None:
            self.email = email
        self.institution = institution
        self.kind_of_relationship = kind_of_relationship
        if numeric_reference is not None:
            self.numeric_reference = numeric_reference
        if payment_concept is not None:
            self.payment_concept = payment_concept
        self.relationship = relationship
        if return_url is not None:
            self.return_url = return_url
        if rfc is not None:
            self.rfc = rfc

    @property
    def amount_limit(self):
        """Gets the amount_limit of this AccountSpid.  # noqa: E501

        Monto límite permitido para la cuenta. Ejemplo: 1000.00  # noqa: E501

        :return: The amount_limit of this AccountSpid.  # noqa: E501
        :rtype: float
        """
        return self._amount_limit

    @amount_limit.setter
    def amount_limit(self, amount_limit):
        """Sets the amount_limit of this AccountSpid.

        Monto límite permitido para la cuenta. Ejemplo: 1000.00  # noqa: E501

        :param amount_limit: The amount_limit of this AccountSpid.  # noqa: E501
        :type: float
        """
        if amount_limit is None:
            raise ValueError("Invalid value for `amount_limit`, must not be `None`")  # noqa: E501

        self._amount_limit = amount_limit

    @property
    def bank_code_banxico(self):
        """Gets the bank_code_banxico of this AccountSpid.  # noqa: E501

        Es el código banxico con una longitud de 5 dígitos, es requerido en caso de que la cuenta del beneficiario sea un número de celular.  # noqa: E501

        :return: The bank_code_banxico of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._bank_code_banxico

    @bank_code_banxico.setter
    def bank_code_banxico(self, bank_code_banxico):
        """Sets the bank_code_banxico of this AccountSpid.

        Es el código banxico con una longitud de 5 dígitos, es requerido en caso de que la cuenta del beneficiario sea un número de celular.  # noqa: E501

        :param bank_code_banxico: The bank_code_banxico of this AccountSpid.  # noqa: E501
        :type: str
        """

        self._bank_code_banxico = bank_code_banxico

    @property
    def beneficiary_account(self):
        """Gets the beneficiary_account of this AccountSpid.  # noqa: E501

        Cuenta del beneficiario debe ser una cuenta CLABE. Ejemplo: 032180000118359719.  # noqa: E501

        :return: The beneficiary_account of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._beneficiary_account

    @beneficiary_account.setter
    def beneficiary_account(self, beneficiary_account):
        """Sets the beneficiary_account of this AccountSpid.

        Cuenta del beneficiario debe ser una cuenta CLABE. Ejemplo: 032180000118359719.  # noqa: E501

        :param beneficiary_account: The beneficiary_account of this AccountSpid.  # noqa: E501
        :type: str
        """
        if beneficiary_account is None:
            raise ValueError("Invalid value for `beneficiary_account`, must not be `None`")  # noqa: E501

        self._beneficiary_account = beneficiary_account

    @property
    def cancel_return_url(self):
        """Gets the cancel_return_url of this AccountSpid.  # noqa: E501

        Es la dirección URL a la que se redirigirá en caso de que el cliente cancele el registro. Se valida hasta 512 caracteres.  # noqa: E501

        :return: The cancel_return_url of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._cancel_return_url

    @cancel_return_url.setter
    def cancel_return_url(self, cancel_return_url):
        """Sets the cancel_return_url of this AccountSpid.

        Es la dirección URL a la que se redirigirá en caso de que el cliente cancele el registro. Se valida hasta 512 caracteres.  # noqa: E501

        :param cancel_return_url: The cancel_return_url of this AccountSpid.  # noqa: E501
        :type: str
        """

        self._cancel_return_url = cancel_return_url

    @property
    def email(self):
        """Gets the email of this AccountSpid.  # noqa: E501

        Lista de correos electrónicos (emails), este dato es opcional.  # noqa: E501

        :return: The email of this AccountSpid.  # noqa: E501
        :rtype: list[str]
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this AccountSpid.

        Lista de correos electrónicos (emails), este dato es opcional.  # noqa: E501

        :param email: The email of this AccountSpid.  # noqa: E501
        :type: list[str]
        """

        self._email = email

    @property
    def institution(self):
        """Gets the institution of this AccountSpid.  # noqa: E501


        :return: The institution of this AccountSpid.  # noqa: E501
        :rtype: BeneficiaryInstitution
        """
        return self._institution

    @institution.setter
    def institution(self, institution):
        """Sets the institution of this AccountSpid.


        :param institution: The institution of this AccountSpid.  # noqa: E501
        :type: BeneficiaryInstitution
        """
        if institution is None:
            raise ValueError("Invalid value for `institution`, must not be `None`")  # noqa: E501

        self._institution = institution

    @property
    def kind_of_relationship(self):
        """Gets the kind_of_relationship of this AccountSpid.  # noqa: E501

        Es el tipo de relación que se tiene con el propietario de la cuenta. Para registrar una cuenta, este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\"> relationships.</a> <br /><br /><b>Nota:</b> <em>Si en la respuesta de Monex esta propiedad es nula, tampoco estará presente en esta respuesta.</em>  # noqa: E501

        :return: The kind_of_relationship of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._kind_of_relationship

    @kind_of_relationship.setter
    def kind_of_relationship(self, kind_of_relationship):
        """Sets the kind_of_relationship of this AccountSpid.

        Es el tipo de relación que se tiene con el propietario de la cuenta. Para registrar una cuenta, este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\"> relationships.</a> <br /><br /><b>Nota:</b> <em>Si en la respuesta de Monex esta propiedad es nula, tampoco estará presente en esta respuesta.</em>  # noqa: E501

        :param kind_of_relationship: The kind_of_relationship of this AccountSpid.  # noqa: E501
        :type: str
        """
        if kind_of_relationship is None:
            raise ValueError("Invalid value for `kind_of_relationship`, must not be `None`")  # noqa: E501

        self._kind_of_relationship = kind_of_relationship

    @property
    def numeric_reference(self):
        """Gets the numeric_reference of this AccountSpid.  # noqa: E501

        Es la referencia numérica.  # noqa: E501

        :return: The numeric_reference of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._numeric_reference

    @numeric_reference.setter
    def numeric_reference(self, numeric_reference):
        """Sets the numeric_reference of this AccountSpid.

        Es la referencia numérica.  # noqa: E501

        :param numeric_reference: The numeric_reference of this AccountSpid.  # noqa: E501
        :type: str
        """

        self._numeric_reference = numeric_reference

    @property
    def payment_concept(self):
        """Gets the payment_concept of this AccountSpid.  # noqa: E501

        Es el concepto de pago.  # noqa: E501

        :return: The payment_concept of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._payment_concept

    @payment_concept.setter
    def payment_concept(self, payment_concept):
        """Sets the payment_concept of this AccountSpid.

        Es el concepto de pago.  # noqa: E501

        :param payment_concept: The payment_concept of this AccountSpid.  # noqa: E501
        :type: str
        """

        self._payment_concept = payment_concept

    @property
    def relationship(self):
        """Gets the relationship of this AccountSpid.  # noqa: E501

        Es la relación con el propietario de la cuenta, para registrar este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">relationships.</a> <br/> <br/> <b>Nota:</b> Si en la respuesta de Monex, sta propiedad es nula, tampoco estará presente en esta respuesta.  # noqa: E501

        :return: The relationship of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._relationship

    @relationship.setter
    def relationship(self, relationship):
        """Sets the relationship of this AccountSpid.

        Es la relación con el propietario de la cuenta, para registrar este valor se debe obtener del recurso <a href=\"#operation/getAvailableRelationshipsMonexUsingGET\">relationships.</a> <br/> <br/> <b>Nota:</b> Si en la respuesta de Monex, sta propiedad es nula, tampoco estará presente en esta respuesta.  # noqa: E501

        :param relationship: The relationship of this AccountSpid.  # noqa: E501
        :type: str
        """
        if relationship is None:
            raise ValueError("Invalid value for `relationship`, must not be `None`")  # noqa: E501

        self._relationship = relationship

    @property
    def return_url(self):
        """Gets the return_url of this AccountSpid.  # noqa: E501

        Es la dirección URL a la que se redirigirá en caso exitoso. Se valida hasta 512 caracteres.  # noqa: E501

        :return: The return_url of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._return_url

    @return_url.setter
    def return_url(self, return_url):
        """Sets the return_url of this AccountSpid.

        Es la dirección URL a la que se redirigirá en caso exitoso. Se valida hasta 512 caracteres.  # noqa: E501

        :param return_url: The return_url of this AccountSpid.  # noqa: E501
        :type: str
        """

        self._return_url = return_url

    @property
    def rfc(self):
        """Gets the rfc of this AccountSpid.  # noqa: E501

        Es el Registro federal de contribuyentes (RFC) de la persona o institución propietaria de la cuenta. <br/> <br/><b>Nota:</b> Se valida el formato de RFC.  # noqa: E501

        :return: The rfc of this AccountSpid.  # noqa: E501
        :rtype: str
        """
        return self._rfc

    @rfc.setter
    def rfc(self, rfc):
        """Sets the rfc of this AccountSpid.

        Es el Registro federal de contribuyentes (RFC) de la persona o institución propietaria de la cuenta. <br/> <br/><b>Nota:</b> Se valida el formato de RFC.  # noqa: E501

        :param rfc: The rfc of this AccountSpid.  # noqa: E501
        :type: str
        """

        self._rfc = rfc

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccountSpid, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountSpid):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
