# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from wire4_client.models.billing_transaction import BillingTransaction  # noqa: F401,E501


class Billing(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'float',
        'emission_at': 'datetime',
        'end_date': 'datetime',
        'id': 'str',
        'start_date': 'datetime',
        'status': 'str',
        'transactions': 'list[BillingTransaction]',
        'url_pdf': 'str',
        'url_xml': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'emission_at': 'emission_at',
        'end_date': 'end_date',
        'id': 'id',
        'start_date': 'start_date',
        'status': 'status',
        'transactions': 'transactions',
        'url_pdf': 'url_pdf',
        'url_xml': 'url_xml'
    }

    def __init__(self, amount=None, emission_at=None, end_date=None, id=None, start_date=None, status=None, transactions=None, url_pdf=None, url_xml=None):  # noqa: E501
        """Billing - a model defined in Swagger"""  # noqa: E501
        self._amount = None
        self._emission_at = None
        self._end_date = None
        self._id = None
        self._start_date = None
        self._status = None
        self._transactions = None
        self._url_pdf = None
        self._url_xml = None
        self.discriminator = None
        if amount is not None:
            self.amount = amount
        if emission_at is not None:
            self.emission_at = emission_at
        if end_date is not None:
            self.end_date = end_date
        if id is not None:
            self.id = id
        if start_date is not None:
            self.start_date = start_date
        if status is not None:
            self.status = status
        if transactions is not None:
            self.transactions = transactions
        if url_pdf is not None:
            self.url_pdf = url_pdf
        if url_xml is not None:
            self.url_xml = url_xml

    @property
    def amount(self):
        """Gets the amount of this Billing.  # noqa: E501

        Monto total de la factura  # noqa: E501

        :return: The amount of this Billing.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Billing.

        Monto total de la factura  # noqa: E501

        :param amount: The amount of this Billing.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def emission_at(self):
        """Gets the emission_at of this Billing.  # noqa: E501

        Fecha y hora en que se emitió de la factura  # noqa: E501

        :return: The emission_at of this Billing.  # noqa: E501
        :rtype: datetime
        """
        return self._emission_at

    @emission_at.setter
    def emission_at(self, emission_at):
        """Sets the emission_at of this Billing.

        Fecha y hora en que se emitió de la factura  # noqa: E501

        :param emission_at: The emission_at of this Billing.  # noqa: E501
        :type: datetime
        """

        self._emission_at = emission_at

    @property
    def end_date(self):
        """Gets the end_date of this Billing.  # noqa: E501

        Fecha en que finaliza el periodo que se factura  # noqa: E501

        :return: The end_date of this Billing.  # noqa: E501
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this Billing.

        Fecha en que finaliza el periodo que se factura  # noqa: E501

        :param end_date: The end_date of this Billing.  # noqa: E501
        :type: datetime
        """

        self._end_date = end_date

    @property
    def id(self):
        """Gets the id of this Billing.  # noqa: E501

        Identificador de la factura  # noqa: E501

        :return: The id of this Billing.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Billing.

        Identificador de la factura  # noqa: E501

        :param id: The id of this Billing.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def start_date(self):
        """Gets the start_date of this Billing.  # noqa: E501

        Fecha de inicio del periodo que se factura  # noqa: E501

        :return: The start_date of this Billing.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this Billing.

        Fecha de inicio del periodo que se factura  # noqa: E501

        :param start_date: The start_date of this Billing.  # noqa: E501
        :type: datetime
        """

        self._start_date = start_date

    @property
    def status(self):
        """Gets the status of this Billing.  # noqa: E501

        Estatus de la factura  # noqa: E501

        :return: The status of this Billing.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Billing.

        Estatus de la factura  # noqa: E501

        :param status: The status of this Billing.  # noqa: E501
        :type: str
        """
        allowed_values = ["PAID", "OMMITED", "WAITING_PAYMENT", "EMISSION_PENDING"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def transactions(self):
        """Gets the transactions of this Billing.  # noqa: E501


        :return: The transactions of this Billing.  # noqa: E501
        :rtype: list[BillingTransaction]
        """
        return self._transactions

    @transactions.setter
    def transactions(self, transactions):
        """Sets the transactions of this Billing.


        :param transactions: The transactions of this Billing.  # noqa: E501
        :type: list[BillingTransaction]
        """

        self._transactions = transactions

    @property
    def url_pdf(self):
        """Gets the url_pdf of this Billing.  # noqa: E501

        Url de la representación impresa en pdf de la factura  # noqa: E501

        :return: The url_pdf of this Billing.  # noqa: E501
        :rtype: str
        """
        return self._url_pdf

    @url_pdf.setter
    def url_pdf(self, url_pdf):
        """Sets the url_pdf of this Billing.

        Url de la representación impresa en pdf de la factura  # noqa: E501

        :param url_pdf: The url_pdf of this Billing.  # noqa: E501
        :type: str
        """

        self._url_pdf = url_pdf

    @property
    def url_xml(self):
        """Gets the url_xml of this Billing.  # noqa: E501

        Url del archivo xml de la factura  # noqa: E501

        :return: The url_xml of this Billing.  # noqa: E501
        :rtype: str
        """
        return self._url_xml

    @url_xml.setter
    def url_xml(self, url_xml):
        """Sets the url_xml of this Billing.

        Url del archivo xml de la factura  # noqa: E501

        :param url_xml: The url_xml of this Billing.  # noqa: E501
        :type: str
        """

        self._url_xml = url_xml

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Billing, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Billing):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
