# coding: utf-8

"""
    Wire4RestAPI

    Referencia de API. La API de Wire4 está organizada en torno a REST  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from wire4_client.models.institution import Institution  # noqa: F401,E501
from wire4_client.models.message_cep import MessageCEP  # noqa: F401,E501


class Payment(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account': 'str',
        'amount': 'float',
        'beneficiary_account': 'str',
        'beneficiary_bank': 'Institution',
        'beneficiary_name': 'str',
        'cep': 'MessageCEP',
        'clave_rastreo': 'str',
        'concept': 'str',
        'confirm_date': 'datetime',
        'currency_code': 'str',
        'detention_message': 'str',
        'error_message': 'str',
        'monex_description': 'str',
        'order_id': 'str',
        'payment_order_id': 'int',
        'pending_reason': 'str',
        'reference': 'int',
        'status_code': 'str',
        'transaction_id': 'int'
    }

    attribute_map = {
        'account': 'account',
        'amount': 'amount',
        'beneficiary_account': 'beneficiary_account',
        'beneficiary_bank': 'beneficiary_bank',
        'beneficiary_name': 'beneficiary_name',
        'cep': 'cep',
        'clave_rastreo': 'clave_rastreo',
        'concept': 'concept',
        'confirm_date': 'confirm_date',
        'currency_code': 'currency_code',
        'detention_message': 'detention_message',
        'error_message': 'error_message',
        'monex_description': 'monex_description',
        'order_id': 'order_id',
        'payment_order_id': 'payment_order_id',
        'pending_reason': 'pending_reason',
        'reference': 'reference',
        'status_code': 'status_code',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, account=None, amount=None, beneficiary_account=None, beneficiary_bank=None, beneficiary_name=None, cep=None, clave_rastreo=None, concept=None, confirm_date=None, currency_code=None, detention_message=None, error_message=None, monex_description=None, order_id=None, payment_order_id=None, pending_reason=None, reference=None, status_code=None, transaction_id=None):  # noqa: E501
        """Payment - a model defined in Swagger"""  # noqa: E501
        self._account = None
        self._amount = None
        self._beneficiary_account = None
        self._beneficiary_bank = None
        self._beneficiary_name = None
        self._cep = None
        self._clave_rastreo = None
        self._concept = None
        self._confirm_date = None
        self._currency_code = None
        self._detention_message = None
        self._error_message = None
        self._monex_description = None
        self._order_id = None
        self._payment_order_id = None
        self._pending_reason = None
        self._reference = None
        self._status_code = None
        self._transaction_id = None
        self.discriminator = None
        if account is not None:
            self.account = account
        if amount is not None:
            self.amount = amount
        if beneficiary_account is not None:
            self.beneficiary_account = beneficiary_account
        if beneficiary_bank is not None:
            self.beneficiary_bank = beneficiary_bank
        if beneficiary_name is not None:
            self.beneficiary_name = beneficiary_name
        if cep is not None:
            self.cep = cep
        if clave_rastreo is not None:
            self.clave_rastreo = clave_rastreo
        if concept is not None:
            self.concept = concept
        if confirm_date is not None:
            self.confirm_date = confirm_date
        if currency_code is not None:
            self.currency_code = currency_code
        if detention_message is not None:
            self.detention_message = detention_message
        if error_message is not None:
            self.error_message = error_message
        if monex_description is not None:
            self.monex_description = monex_description
        if order_id is not None:
            self.order_id = order_id
        if payment_order_id is not None:
            self.payment_order_id = payment_order_id
        if pending_reason is not None:
            self.pending_reason = pending_reason
        if reference is not None:
            self.reference = reference
        if status_code is not None:
            self.status_code = status_code
        if transaction_id is not None:
            self.transaction_id = transaction_id

    @property
    def account(self):
        """Gets the account of this Payment.  # noqa: E501

        Es la uenta emisora.  # noqa: E501

        :return: The account of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this Payment.

        Es la uenta emisora.  # noqa: E501

        :param account: The account of this Payment.  # noqa: E501
        :type: str
        """

        self._account = account

    @property
    def amount(self):
        """Gets the amount of this Payment.  # noqa: E501

        Es el monto de la transferencia.  # noqa: E501

        :return: The amount of this Payment.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Payment.

        Es el monto de la transferencia.  # noqa: E501

        :param amount: The amount of this Payment.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def beneficiary_account(self):
        """Gets the beneficiary_account of this Payment.  # noqa: E501

        Es la cuenta del beneficiario.  # noqa: E501

        :return: The beneficiary_account of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._beneficiary_account

    @beneficiary_account.setter
    def beneficiary_account(self, beneficiary_account):
        """Sets the beneficiary_account of this Payment.

        Es la cuenta del beneficiario.  # noqa: E501

        :param beneficiary_account: The beneficiary_account of this Payment.  # noqa: E501
        :type: str
        """

        self._beneficiary_account = beneficiary_account

    @property
    def beneficiary_bank(self):
        """Gets the beneficiary_bank of this Payment.  # noqa: E501


        :return: The beneficiary_bank of this Payment.  # noqa: E501
        :rtype: Institution
        """
        return self._beneficiary_bank

    @beneficiary_bank.setter
    def beneficiary_bank(self, beneficiary_bank):
        """Sets the beneficiary_bank of this Payment.


        :param beneficiary_bank: The beneficiary_bank of this Payment.  # noqa: E501
        :type: Institution
        """

        self._beneficiary_bank = beneficiary_bank

    @property
    def beneficiary_name(self):
        """Gets the beneficiary_name of this Payment.  # noqa: E501

        Es el nombre del Beneficiario.  # noqa: E501

        :return: The beneficiary_name of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._beneficiary_name

    @beneficiary_name.setter
    def beneficiary_name(self, beneficiary_name):
        """Sets the beneficiary_name of this Payment.

        Es el nombre del Beneficiario.  # noqa: E501

        :param beneficiary_name: The beneficiary_name of this Payment.  # noqa: E501
        :type: str
        """

        self._beneficiary_name = beneficiary_name

    @property
    def cep(self):
        """Gets the cep of this Payment.  # noqa: E501


        :return: The cep of this Payment.  # noqa: E501
        :rtype: MessageCEP
        """
        return self._cep

    @cep.setter
    def cep(self, cep):
        """Sets the cep of this Payment.


        :param cep: The cep of this Payment.  # noqa: E501
        :type: MessageCEP
        """

        self._cep = cep

    @property
    def clave_rastreo(self):
        """Gets the clave_rastreo of this Payment.  # noqa: E501

        Es la clave de rastreo de la transferencia.  # noqa: E501

        :return: The clave_rastreo of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._clave_rastreo

    @clave_rastreo.setter
    def clave_rastreo(self, clave_rastreo):
        """Sets the clave_rastreo of this Payment.

        Es la clave de rastreo de la transferencia.  # noqa: E501

        :param clave_rastreo: The clave_rastreo of this Payment.  # noqa: E501
        :type: str
        """

        self._clave_rastreo = clave_rastreo

    @property
    def concept(self):
        """Gets the concept of this Payment.  # noqa: E501

        Es el concepto de pago.  # noqa: E501

        :return: The concept of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._concept

    @concept.setter
    def concept(self, concept):
        """Sets the concept of this Payment.

        Es el concepto de pago.  # noqa: E501

        :param concept: The concept of this Payment.  # noqa: E501
        :type: str
        """

        self._concept = concept

    @property
    def confirm_date(self):
        """Gets the confirm_date of this Payment.  # noqa: E501

        Es la fecha de aplicación de la transferencia. Ésta fecha viene en formato ISO 8601 con zona horaria, ejemplo: <strong>2020-10-27T11:03:15.000-06:00</strong>.  # noqa: E501

        :return: The confirm_date of this Payment.  # noqa: E501
        :rtype: datetime
        """
        return self._confirm_date

    @confirm_date.setter
    def confirm_date(self, confirm_date):
        """Sets the confirm_date of this Payment.

        Es la fecha de aplicación de la transferencia. Ésta fecha viene en formato ISO 8601 con zona horaria, ejemplo: <strong>2020-10-27T11:03:15.000-06:00</strong>.  # noqa: E501

        :param confirm_date: The confirm_date of this Payment.  # noqa: E501
        :type: datetime
        """

        self._confirm_date = confirm_date

    @property
    def currency_code(self):
        """Gets the currency_code of this Payment.  # noqa: E501

        Es el código de divisa de la transferencia. Es en el formato estándar de 3 dígitos. Ejemplo del peso mexicano: <b>MXP</b>, ejemplo del dólar estadounidense: <b>USD</b>.  # noqa: E501

        :return: The currency_code of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this Payment.

        Es el código de divisa de la transferencia. Es en el formato estándar de 3 dígitos. Ejemplo del peso mexicano: <b>MXP</b>, ejemplo del dólar estadounidense: <b>USD</b>.  # noqa: E501

        :param currency_code: The currency_code of this Payment.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def detention_message(self):
        """Gets the detention_message of this Payment.  # noqa: E501

        Es el mensaje proporcionado por Monex para la transferencia.  # noqa: E501

        :return: The detention_message of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._detention_message

    @detention_message.setter
    def detention_message(self, detention_message):
        """Sets the detention_message of this Payment.

        Es el mensaje proporcionado por Monex para la transferencia.  # noqa: E501

        :param detention_message: The detention_message of this Payment.  # noqa: E501
        :type: str
        """

        self._detention_message = detention_message

    @property
    def error_message(self):
        """Gets the error_message of this Payment.  # noqa: E501

        Es el mensaje de error, en caso de algún error se informará aquí.  # noqa: E501

        :return: The error_message of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this Payment.

        Es el mensaje de error, en caso de algún error se informará aquí.  # noqa: E501

        :param error_message: The error_message of this Payment.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    @property
    def monex_description(self):
        """Gets the monex_description of this Payment.  # noqa: E501

        Es la descripción de Monex.  # noqa: E501

        :return: The monex_description of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._monex_description

    @monex_description.setter
    def monex_description(self, monex_description):
        """Sets the monex_description of this Payment.

        Es la descripción de Monex.  # noqa: E501

        :param monex_description: The monex_description of this Payment.  # noqa: E501
        :type: str
        """

        self._monex_description = monex_description

    @property
    def order_id(self):
        """Gets the order_id of this Payment.  # noqa: E501

        Es el identificador asignado por la aplciación a la transferencia.  # noqa: E501

        :return: The order_id of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this Payment.

        Es el identificador asignado por la aplciación a la transferencia.  # noqa: E501

        :param order_id: The order_id of this Payment.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def payment_order_id(self):
        """Gets the payment_order_id of this Payment.  # noqa: E501

        Es el identificador de la orden de pago en Monex.  # noqa: E501

        :return: The payment_order_id of this Payment.  # noqa: E501
        :rtype: int
        """
        return self._payment_order_id

    @payment_order_id.setter
    def payment_order_id(self, payment_order_id):
        """Sets the payment_order_id of this Payment.

        Es el identificador de la orden de pago en Monex.  # noqa: E501

        :param payment_order_id: The payment_order_id of this Payment.  # noqa: E501
        :type: int
        """

        self._payment_order_id = payment_order_id

    @property
    def pending_reason(self):
        """Gets the pending_reason of this Payment.  # noqa: E501

        Es la razón de porque esta pendiente aún cuando se autorizó la transferencia.  # noqa: E501

        :return: The pending_reason of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._pending_reason

    @pending_reason.setter
    def pending_reason(self, pending_reason):
        """Sets the pending_reason of this Payment.

        Es la razón de porque esta pendiente aún cuando se autorizó la transferencia.  # noqa: E501

        :param pending_reason: The pending_reason of this Payment.  # noqa: E501
        :type: str
        """

        self._pending_reason = pending_reason

    @property
    def reference(self):
        """Gets the reference of this Payment.  # noqa: E501

        Es la referencia numérica.  # noqa: E501

        :return: The reference of this Payment.  # noqa: E501
        :rtype: int
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this Payment.

        Es la referencia numérica.  # noqa: E501

        :param reference: The reference of this Payment.  # noqa: E501
        :type: int
        """

        self._reference = reference

    @property
    def status_code(self):
        """Gets the status_code of this Payment.  # noqa: E501

        Es el estado de la transferencia de la transferencia, los posibles valores son: <b>PENDING, COMPLETED, FAILED, CANCELLED</b>  # noqa: E501

        :return: The status_code of this Payment.  # noqa: E501
        :rtype: str
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """Sets the status_code of this Payment.

        Es el estado de la transferencia de la transferencia, los posibles valores son: <b>PENDING, COMPLETED, FAILED, CANCELLED</b>  # noqa: E501

        :param status_code: The status_code of this Payment.  # noqa: E501
        :type: str
        """

        self._status_code = status_code

    @property
    def transaction_id(self):
        """Gets the transaction_id of this Payment.  # noqa: E501

        Es el identificador de la transferencia asignado por Monex.  # noqa: E501

        :return: The transaction_id of this Payment.  # noqa: E501
        :rtype: int
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this Payment.

        Es el identificador de la transferencia asignado por Monex.  # noqa: E501

        :param transaction_id: The transaction_id of this Payment.  # noqa: E501
        :type: int
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Payment, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Payment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
