"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseInstance = exports.DatabaseInstanceBase = exports.InstanceType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const ec2 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib");
const endpoint_1 = require("./endpoint");
const aws_neptune_1 = require("aws-cdk-lib/aws-neptune");
/**
 * Possible Instances Types to use in Neptune cluster
 * used for defining `DatabaseInstanceProps.instanceType`.
 */
class InstanceType {
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('db.')) {
            this._instanceType = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'db.'; (got ${instanceType})`);
        }
    }
    /**
     * Build an InstanceType from given string or token, such as CfnParameter.
     */
    static of(instanceType) {
        return new InstanceType(instanceType);
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-neptune-alpha.InstanceType", version: "2.64.0-alpha.0" };
/**
 * db.r6g.large
 */
InstanceType.R6G_LARGE = InstanceType.of('db.r6g.large');
/**
 * db.r6g.xlarge
 */
InstanceType.R6G_XLARGE = InstanceType.of('db.r6g.xlarge');
/**
 * db.r6g.2xlarge
 */
InstanceType.R6G_2XLARGE = InstanceType.of('db.r6g.2xlarge');
/**
 * db.r6g.4xlarge
 */
InstanceType.R6G_4XLARGE = InstanceType.of('db.r6g.4xlarge');
/**
 * db.r6g.8xlarge
 */
InstanceType.R6G_8XLARGE = InstanceType.of('db.r6g.8xlarge');
/**
* db.r6g.12xlarge
*/
InstanceType.R6G_12XLARGE = InstanceType.of('db.r6g.12xlarge');
/**
 * db.r6g.16xlarge
 */
InstanceType.R6G_16XLARGE = InstanceType.of('db.r6g.16xlarge');
/**
 * db.t4g.medium
 */
InstanceType.T4G_MEDIUM = InstanceType.of('db.t4g.medium');
/**
 * db.r5.large
 */
InstanceType.R5_LARGE = InstanceType.of('db.r5.large');
/**
 * db.r5.xlarge
 */
InstanceType.R5_XLARGE = InstanceType.of('db.r5.xlarge');
/**
 * db.r5.2xlarge
 */
InstanceType.R5_2XLARGE = InstanceType.of('db.r5.2xlarge');
/**
 * db.r5.4xlarge
 */
InstanceType.R5_4XLARGE = InstanceType.of('db.r5.4xlarge');
/**
 * db.r5.8xlarge
 */
InstanceType.R5_8XLARGE = InstanceType.of('db.r5.8xlarge');
/**
 * db.r5.12xlarge
 */
InstanceType.R5_12XLARGE = InstanceType.of('db.r5.12xlarge');
/**
 * db.r5.24xlarge
 */
InstanceType.R5_24XLARGE = InstanceType.of('db.r5.24xlarge');
/**
 * db.r4.large
 */
InstanceType.R4_LARGE = InstanceType.of('db.r4.large');
/**
 * db.r4.xlarge
 */
InstanceType.R4_XLARGE = InstanceType.of('db.r4.xlarge');
/**
 * db.r4.2xlarge
 */
InstanceType.R4_2XLARGE = InstanceType.of('db.r4.2xlarge');
/**
 * db.r4.4xlarge
 */
InstanceType.R4_4XLARGE = InstanceType.of('db.r4.4xlarge');
/**
 * db.r4.8xlarge
 */
InstanceType.R4_8XLARGE = InstanceType.of('db.r4.8xlarge');
/**
 * db.t3.medium
 */
InstanceType.T3_MEDIUM = InstanceType.of('db.t3.medium');
/**
 * A new or imported database instance.
 */
class DatabaseInstanceBase extends cdk.Resource {
    /**
     * Import an existing database instance.
     */
    static fromDatabaseInstanceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_neptune_alpha_DatabaseInstanceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDatabaseInstanceAttributes);
            }
            throw error;
        }
        class Import extends DatabaseInstanceBase {
            constructor() {
                super(...arguments);
                this.defaultPort = ec2.Port.tcp(attrs.port);
                this.instanceIdentifier = attrs.instanceIdentifier;
                this.dbInstanceEndpointAddress = attrs.instanceEndpointAddress;
                this.dbInstanceEndpointPort = attrs.port.toString();
                this.instanceEndpoint = new endpoint_1.Endpoint(attrs.instanceEndpointAddress, attrs.port);
            }
        }
        return new Import(scope, id);
    }
    /**
     * @inheritdoc
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Neptune',
            dimensionsMap: {
                DBInstanceIdentifier: this.instanceIdentifier,
            },
            metricName,
            ...props,
        });
    }
}
exports.DatabaseInstanceBase = DatabaseInstanceBase;
_b = JSII_RTTI_SYMBOL_1;
DatabaseInstanceBase[_b] = { fqn: "@aws-cdk/aws-neptune-alpha.DatabaseInstanceBase", version: "2.64.0-alpha.0" };
/**
 * A database instance
 *
 * @resource AWS::Neptune::DBInstance
 */
class DatabaseInstance extends DatabaseInstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_neptune_alpha_DatabaseInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DatabaseInstance);
            }
            throw error;
        }
        const instance = new aws_neptune_1.CfnDBInstance(this, 'Resource', {
            dbClusterIdentifier: props.cluster.clusterIdentifier,
            dbInstanceClass: props.instanceType._instanceType,
            availabilityZone: props.availabilityZone,
            dbInstanceIdentifier: props.dbInstanceName,
            dbParameterGroupName: props.parameterGroup?.parameterGroupName,
        });
        this.cluster = props.cluster;
        this.instanceIdentifier = instance.ref;
        this.dbInstanceEndpointAddress = instance.attrEndpoint;
        this.dbInstanceEndpointPort = instance.attrPort;
        // create a number token that represents the port of the instance
        const portAttribute = cdk.Token.asNumber(instance.attrPort);
        this.instanceEndpoint = new endpoint_1.Endpoint(instance.attrEndpoint, portAttribute);
        instance.applyRemovalPolicy(props.removalPolicy, {
            applyToUpdateReplacePolicy: true,
        });
    }
}
exports.DatabaseInstance = DatabaseInstance;
_c = JSII_RTTI_SYMBOL_1;
DatabaseInstance[_c] = { fqn: "@aws-cdk/aws-neptune-alpha.DatabaseInstance", version: "2.64.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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