import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * The DB parameter group family that a DB parameter group is compatible with
 */
export declare class ParameterGroupFamily {
    readonly family: string;
    /**
     * Family used by Neptune engine versions before 1.2.0.0
     */
    static readonly NEPTUNE_1: ParameterGroupFamily;
    /**
     * Family used by Neptune engine versions 1.2.0.0 and later
     */
    static readonly NEPTUNE_1_2: ParameterGroupFamily;
    /**
     * Constructor for specifying a custom parameter group famil
     * @param family the family of the parameter group Neptune
     */
    constructor(family: string);
}
/**
 * Properties for a parameter group
 */
interface ParameterGroupPropsBase {
    /**
     * Description for this parameter group
     *
     * @default a CDK generated description
     */
    readonly description?: string;
    /**
     * The parameters in this parameter group
     */
    readonly parameters: {
        [key: string]: string;
    };
    /**
     * Parameter group family
     *
     * @default - NEPTUNE_1
     */
    readonly family?: ParameterGroupFamily;
}
/**
 * Marker class for cluster parameter group
 */
export interface ClusterParameterGroupProps extends ParameterGroupPropsBase {
    /**
     * The name of the parameter group
     *
     * @default A CDK generated name for the parameter group
     */
    readonly clusterParameterGroupName?: string;
}
/**
 * Marker class for cluster parameter group
 */
export interface ParameterGroupProps extends ParameterGroupPropsBase {
    /**
     * The name of the parameter group
     *
     * @default A CDK generated name for the parameter group
     */
    readonly parameterGroupName?: string;
}
/**
 * A parameter group
 */
export interface IClusterParameterGroup extends IResource {
    /**
     * The name of this parameter group
     */
    readonly clusterParameterGroupName: string;
}
/**
 * A cluster parameter group
 *
 * @resource AWS::Neptune::DBClusterParameterGroup
 */
export declare class ClusterParameterGroup extends Resource implements IClusterParameterGroup {
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope: Construct, id: string, clusterParameterGroupName: string): IClusterParameterGroup;
    /**
     * The name of the parameter group
     */
    readonly clusterParameterGroupName: string;
    constructor(scope: Construct, id: string, props: ClusterParameterGroupProps);
}
/**
 * A parameter group
 */
export interface IParameterGroup extends IResource {
    /**
     * The name of this parameter group
     */
    readonly parameterGroupName: string;
}
/**
 * DB parameter group
 *
 * @resource AWS::Neptune::DBParameterGroup
 */
export declare class ParameterGroup extends Resource implements IParameterGroup {
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope: Construct, id: string, parameterGroupName: string): IParameterGroup;
    /**
     * The name of the parameter group
     */
    readonly parameterGroupName: string;
    constructor(scope: Construct, id: string, props: ParameterGroupProps);
}
export {};
