"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterGroup = exports.ClusterParameterGroup = exports.ParameterGroupFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_neptune_1 = require("aws-cdk-lib/aws-neptune");
/**
 * The DB parameter group family that a DB parameter group is compatible with
 */
class ParameterGroupFamily {
    /**
     * Constructor for specifying a custom parameter group famil
     * @param family the family of the parameter group Neptune
     */
    constructor(family) {
        this.family = family;
    }
}
exports.ParameterGroupFamily = ParameterGroupFamily;
_a = JSII_RTTI_SYMBOL_1;
ParameterGroupFamily[_a] = { fqn: "@aws-cdk/aws-neptune-alpha.ParameterGroupFamily", version: "2.64.0-alpha.0" };
/**
 * Family used by Neptune engine versions before 1.2.0.0
 */
ParameterGroupFamily.NEPTUNE_1 = new ParameterGroupFamily('neptune1');
/**
 * Family used by Neptune engine versions 1.2.0.0 and later
 */
ParameterGroupFamily.NEPTUNE_1_2 = new ParameterGroupFamily('neptune1.2');
/**
 * A cluster parameter group
 *
 * @resource AWS::Neptune::DBClusterParameterGroup
 */
class ClusterParameterGroup extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_neptune_alpha_ClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ClusterParameterGroup);
            }
            throw error;
        }
        const resource = new aws_neptune_1.CfnDBClusterParameterGroup(this, 'Resource', {
            name: props.clusterParameterGroupName,
            description: props.description || 'Cluster parameter group for neptune db cluster',
            family: (props.family ?? ParameterGroupFamily.NEPTUNE_1).family,
            parameters: props.parameters,
        });
        this.clusterParameterGroupName = resource.ref;
    }
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope, id, clusterParameterGroupName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterParameterGroupName = clusterParameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_b = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_b] = { fqn: "@aws-cdk/aws-neptune-alpha.ClusterParameterGroup", version: "2.64.0-alpha.0" };
/**
 * DB parameter group
 *
 * @resource AWS::Neptune::DBParameterGroup
 */
class ParameterGroup extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_neptune_alpha_ParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ParameterGroup);
            }
            throw error;
        }
        const resource = new aws_neptune_1.CfnDBParameterGroup(this, 'Resource', {
            name: props.parameterGroupName,
            description: props.description || 'Instance parameter group for neptune db instances',
            family: (props.family ?? ParameterGroupFamily.NEPTUNE_1).family,
            parameters: props.parameters,
        });
        this.parameterGroupName = resource.ref;
    }
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.parameterGroupName = parameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ParameterGroup = ParameterGroup;
_c = JSII_RTTI_SYMBOL_1;
ParameterGroup[_c] = { fqn: "@aws-cdk/aws-neptune-alpha.ParameterGroup", version: "2.64.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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