import { ScalingInterval } from './types';
/**
 * @stability stable
 */
export interface CompleteScalingInterval {
    /**
     * @stability stable
     */
    readonly lower: number;
    /**
     * @stability stable
     */
    readonly upper: number;
    /**
     * @stability stable
     */
    readonly change?: number;
}
/**
 * Normalize the given interval set to cover the complete number line and make sure it has at most one gap
 */
export declare function normalizeIntervals(intervals: ScalingInterval[], changesAreAbsolute: boolean): CompleteScalingInterval[];
/**
 * @stability stable
 */
export interface Alarms {
    /**
     * @stability stable
     */
    readonly lowerAlarmIntervalIndex?: number;
    /**
     * @stability stable
     */
    readonly upperAlarmIntervalIndex?: number;
}
/**
 * Locate the intervals that should have the alarm thresholds, by index.
 *
 * Pick the intervals on either side of the singleton "undefined" interval, or
 * pick the middle interval if there's no such interval.
 */
export declare function findAlarmThresholds(intervals: CompleteScalingInterval[]): Alarms;
