#      Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#      This program is free software: you can redistribute it and/or modify
#      it under the terms of the GNU Affero General Public License as
#      published by the Free Software Foundation, either version 3 of the
#      License, or (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU Affero General Public License for more details.
#
#      You should have received a copy of the GNU Affero General Public License
#      along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Generated by Django 2.2 on 2019-05-08 14:22

import datetime
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import nobinobi_daily_follow_up.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('nobinobi_child', '0004_auto_20190531_1027'),
        ('nobinobi_staff', '0006_staff_working_base'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActivityGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Activity group',
                'verbose_name_plural': 'Activities groups',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Lotion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Lotion',
                'verbose_name_plural': 'Lotions',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Meal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('image', models.ImageField(blank=True, null=True, upload_to=nobinobi_daily_follow_up.models.Meal.upload_image_meal, verbose_name='Image')),
            ],
            options={
                'verbose_name': 'Meal',
                'verbose_name_plural': 'Meals',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Presence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('date', models.DateField(verbose_name='Date')),
                ('arrival_time', models.TimeField(verbose_name='Arrival time')),
                ('departure_time', models.TimeField(verbose_name='Departure time')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.Child', verbose_name='Child')),
                ('classroom', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_child.Classroom', verbose_name='Classroom')),
            ],
            options={
                'verbose_name': 'Presence',
                'verbose_name_plural': 'Presences',
                'ordering': ('date',),
                'unique_together': {('child', 'date')},
            },
        ),
        migrations.CreateModel(
            name='TypeMedication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Type medication',
                'verbose_name_plural': 'Types medications',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='DailyFollowUp',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('presence', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='nobinobi_daily_follow_up.Presence')),
                ('important', models.BooleanField(default=False, verbose_name='Important')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Commentaire')),
            ],
            options={
                'verbose_name': 'Daily follow-up',
                'verbose_name_plural': 'Daily follow-ups',
                'ordering': ('presence',),
            },
        ),
        migrations.CreateModel(
            name='TypeActivity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('order', models.PositiveSmallIntegerField(verbose_name='Ordre')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.ActivityGroup', verbose_name='Group')),
            ],
            options={
                'verbose_name': 'Type activity',
                'verbose_name_plural': 'Types activities',
                'ordering': ('order', 'name', 'group'),
            },
        ),
        migrations.CreateModel(
            name='Medication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', model_utils.fields.SplitField(blank=True, no_excerpt_field=True, null=True, verbose_name='Commentaire')),
                ('attachment', models.FileField(blank=True, null=True, upload_to=nobinobi_daily_follow_up.models.Medication.attachment_file_medication, verbose_name='Attachment')),
                ('_comment_excerpt', models.TextField(editable=False)),
                ('type_medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.TypeMedication', verbose_name='Type medication')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Daily follow-up')),
            ],
            options={
                'verbose_name': 'Medication',
                'verbose_name_plural': 'Medications',
                'ordering': ('daily_follow_up', 'type_medication'),
            },
        ),
        migrations.CreateModel(
            name='GiveMedication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('give_hour', models.TimeField(verbose_name='Give hour')),
                ('given_hour', models.TimeField(blank=True, null=True, verbose_name='Given hour')),
                ('medication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.Medication', verbose_name='Medication')),
                ('staff', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_staff.Staff', verbose_name='Personnel')),
            ],
            options={
                'verbose_name': 'Give medication',
                'verbose_name_plural': 'Give medications',
                'ordering': ('medication',),
            },
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', model_utils.fields.SplitField(blank=True, no_excerpt_field=True, null=True, verbose_name='Commentaire')),
                ('_comment_excerpt', models.TextField(editable=False)),
                ('type_activity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.TypeActivity', verbose_name='Type activity')),
            ],
            options={
                'verbose_name': 'Activity',
                'verbose_name_plural': 'Activities',
                'ordering': ('daily_follow_up', 'type_activity'),
            },
        ),
        migrations.CreateModel(
            name='Reception',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('daily_follow_up', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='nobinobi_daily_follow_up.DailyFollowUp')),
                ('wake_up_time', models.TimeField(choices=[(datetime.time(5, 0), '05H00'), (datetime.time(5, 15), '05H15'), (datetime.time(5, 30), '05H30'), (datetime.time(5, 45), '05H45'), (datetime.time(6, 0), '06H00'), (datetime.time(6, 15), '06H15'), (datetime.time(6, 30), '06H30'), (datetime.time(6, 45), '06H45'), (datetime.time(7, 0), '07H00'), (datetime.time(7, 15), '07H15'), (datetime.time(7, 30), '07H30'), (datetime.time(7, 45), '07H45'), (datetime.time(8, 0), '08H00')], default=datetime.time(6, 0), null=True, verbose_name='Wake up time')),
                ('sleep', models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('bad', 'spook.png')], default='good', max_length=10, null=True, verbose_name='Sleep')),
                ('breakfast', models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], default='very_good', max_length=20, null=True, verbose_name='Breakfast')),
                ('breakfast_time', models.TimeField(blank=True, null=True, verbose_name='Breakfast time')),
                ('condition', models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('sick', 'spook.png')], default='very_good', max_length=10, null=True, verbose_name='Condition')),
                ('fever', models.CharField(choices=[('no', 'Non'), ('37', '37'), ('37.5', '37.5'), ('38', '38'), ('38.5', '38.5'), ('39', '39'), ('39.5', '39.5'), ('40', '40')], default='no', max_length=10, null=True, verbose_name='Fever')),
                ('sick', models.CharField(choices=[('no', 'Non'), ('gastroenteritis', 'Gastroenteritis'), ('conjunctivitis', 'Conjunctivitis'), ('cough', 'Cough'), ('cold', 'Cold')], default='no', max_length=25, null=True, verbose_name='Sick')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Commentaire')),
            ],
            options={
                'verbose_name': 'Reception',
                'verbose_name_plural': 'Receptions',
                'ordering': ('daily_follow_up',),
            },
        ),
        migrations.CreateModel(
            name='Nap',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('start_time', models.TimeField(verbose_name='Start time')),
                ('end_time', models.TimeField(verbose_name='End time')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Daily follow-up')),
            ],
            options={
                'verbose_name': 'Nap',
                'verbose_name_plural': 'Naps',
                'ordering': ('start_time', 'end_time'),
            },
        ),
        migrations.CreateModel(
            name='LotionDailyFollowUp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', model_utils.fields.SplitField(blank=True, no_excerpt_field=True, null=True, verbose_name='Commentaire')),
                ('_comment_excerpt', models.TextField(editable=False)),
                ('lotion', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.Lotion', verbose_name='Lotion')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Daily follow-up')),
            ],
            options={
                'verbose_name': 'Lotion daily follow-up',
                'verbose_name_plural': 'Lotion daily follow-ups',
                'ordering': ('daily_follow_up',),
            },
        ),
        migrations.CreateModel(
            name='DiaperChange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('hour', models.TimeField(verbose_name='Hour')),
                ('feces', models.CharField(choices=[('feces', 'caca.png'), ('nothing', 'nothing.png')], default='nothing', max_length=15, verbose_name='Feces')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Daily follow-up')),
            ],
            options={
                'verbose_name': 'Diaper change',
                'verbose_name_plural': 'Diapers changes',
                'ordering': ('daily_follow_up', 'hour'),
            },
        ),
        migrations.AddField(
            model_name='dailyfollowup',
            name='activities',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Activity', to='nobinobi_daily_follow_up.TypeActivity', verbose_name='Activities'),
        ),
        migrations.AddField(
            model_name='dailyfollowup',
            name='lotions',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.LotionDailyFollowUp', to='nobinobi_daily_follow_up.Lotion', verbose_name='Lotions'),
        ),
        migrations.AddField(
            model_name='dailyfollowup',
            name='medications',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Medication', to='nobinobi_daily_follow_up.TypeMedication', verbose_name='Medications'),
        ),
        migrations.AddField(
            model_name='activity',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Daily follow-up'),
        ),
        migrations.CreateModel(
            name='MealDailyFollowUp',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('daily_follow_up', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='nobinobi_daily_follow_up.DailyFollowUp')),
                ('snack_time', models.TimeField(blank=True, null=True, verbose_name='Snack time')),
                ('snack_quality', models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], max_length=10, null=True, verbose_name='Snack quality')),
                ('lunch_time', models.TimeField(blank=True, null=True, verbose_name='Lunch time')),
                ('lunch_quality', models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], max_length=10, null=True, verbose_name='Lunch quality')),
                ('afternoon_snack_time', models.TimeField(blank=True, null=True, verbose_name='Afternoon snack time')),
                ('afternoon_snack_quality', models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], max_length=10, null=True, verbose_name='Afternoon snack quality')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Commentaire')),
                ('afternoon_snack_meals', models.ManyToManyField(blank=True, related_name='afternoon_snack_meals', to='nobinobi_daily_follow_up.Meal', verbose_name='Afternoon snack meals')),
                ('lunch_meals', models.ManyToManyField(blank=True, related_name='lunch_meals', to='nobinobi_daily_follow_up.Meal', verbose_name='Lunch meals')),
                ('snack_meals', models.ManyToManyField(blank=True, related_name='snack_meals', to='nobinobi_daily_follow_up.Meal', verbose_name='Snack meals')),
            ],
            options={
                'verbose_name': 'Meal daily follow-up',
                'verbose_name_plural': 'Meal daily follow-ups',
                'ordering': ('daily_follow_up',),
            },
        ),
    ]
