#      Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#      This program is free software: you can redistribute it and/or modify
#      it under the terms of the GNU Affero General Public License as
#      published by the Free Software Foundation, either version 3 of the
#      License, or (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU Affero General Public License for more details.
#
#      You should have received a copy of the GNU Affero General Public License
#      along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Generated by Django 2.2 on 2019-09-23 13:17

import datetime

import django.db.models.deletion
from django.db import migrations, models
from django.utils.timezone import utc


class Migration(migrations.Migration):

    dependencies = [
        ('nobinobi_daily_follow_up', '0004_auto_20190815_1141'),
    ]

    operations = [
        migrations.CreateModel(
            name='DailyFollowUpToMedication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'Daily Follow-up to Medication',
                'ordering': ('daily_follow_up', 'medication'),
            },
        ),
        migrations.AlterModelOptions(
            name='medication',
            options={'ordering': ('from_date', 'end_date', 'type_medication'), 'verbose_name': 'Médicament', 'verbose_name_plural': 'Médicaments'},
        ),
        migrations.RemoveField(
            model_name='medication',
            name='daily_follow_up',
        ),
        migrations.AddField(
            model_name='medication',
            name='end_date',
            field=models.DateField(default=datetime.datetime(2019, 9, 23, 13, 17, 47, 116305, tzinfo=utc), verbose_name='Date de fin'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='medication',
            name='from_date',
            field=models.DateField(default=datetime.datetime(2019, 9, 23, 13, 17, 54, 284229, tzinfo=utc), verbose_name='Date de début'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='medications',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.DailyFollowUpToMedication', to='nobinobi_daily_follow_up.Medication', verbose_name='Médicaments'),
        ),
        migrations.AddField(
            model_name='dailyfollowuptomedication',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AddField(
            model_name='dailyfollowuptomedication',
            name='medication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.Medication', verbose_name='Médicament'),
        ),
    ]
