# Generated by Django 2.2.17 on 2021-01-28 01:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('discounts', '0012_existing_discounts_applied'),
        ('vouchers', '0012_existing_vouchers_applied'),
        ('core', '0034_update_reg_data'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='temporaryregistration',
            name='submissionUser',
        ),
        migrations.RemoveField(
            model_name='invoice',
            name='finalRegistration',
        ),
        migrations.RemoveField(
            model_name='invoice',
            name='temporaryRegistration',
        ),
        migrations.RemoveField(
            model_name='invoiceitem',
            name='finalEventRegistration',
        ),
        migrations.RemoveField(
            model_name='invoiceitem',
            name='temporaryEventRegistration',
        ),
        migrations.RemoveField(
            model_name='registration',
            name='temporaryRegistration',
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='invoiceItem',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='eventRegistration', to='core.InvoiceItem', verbose_name='Invoice item'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='occurrences',
            field=models.ManyToManyField(blank=True, to='core.EventOccurrence', verbose_name='Applicable event occurrences (for drop-ins only)'),
        ),
        migrations.AddField(
            model_name='invoice',
            name='expirationDate',
            field=models.DateTimeField(blank=True, help_text='Invoices that are not yet permanent (preliminary invoices) can expire and may automatically be removed if they are past their expireation date. Typically, these are invoices associated with temporary registrations that are never completed.', null=True, verbose_name='Expiration date'),
        ),
        migrations.AddField(
            model_name='registration',
            name='expirationDate',
            field=models.DateTimeField(blank=True, help_text='When a customer attempts to begin the registration process, the system looks for temporary registrations that are still in progress (with a future expiration date) to determine if there is space for them to register.', null=True, verbose_name='Expiration date'),
        ),
        migrations.AddField(
            model_name='registration',
            name='final',
            field=models.BooleanField(null=True, verbose_name='Registration has been finalized'),
        ),
        migrations.AddField(
            model_name='registration',
            name='invoice',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='registration', to='core.Invoice', verbose_name='Invoice'),
        ),
        migrations.AddField(
            model_name='registration',
            name='email',
            field=models.CharField(max_length=200, null=True, verbose_name='Email address'),
        ),
        migrations.AddField(
            model_name='registration',
            name='phone',
            field=models.CharField(blank=True, max_length=20, null=True, verbose_name='Telephone'),
        ),
        migrations.AddField(
            model_name='registration',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='submittedregistrations', to=settings.AUTH_USER_MODEL, verbose_name='registered by user'),
        ),
        migrations.AlterField(
            model_name='invoice',
            name='status',
            field=models.CharField(choices=[('0', 'Preliminary'), ('U', 'Unpaid'), ('A', 'Authorized using payment processor'), ('P', 'Paid'), ('N', 'Processed but no payment collected'), ('R', 'Refunded in full'), ('C', 'Cancelled'), ('X', 'Rejected in processing'), ('E', 'Error in processing')], default='0', max_length=1, verbose_name='Payment status'),
        ),
        migrations.DeleteModel(
            name='TemporaryEventRegistration',
        ),
        migrations.DeleteModel(
            name='TemporaryRegistration',
        ),
    ]
