# Generated by Django 3.1.6 on 2021-02-20 15:24

from django.db import migrations
from django.db.models import F


def calculate_taxrate(apps, schema_editor):
    '''
    Calculate the tax rate based on current totals for any InvoiceItem that
    does not currently have a tax rate, so that we can make taxRate non-nullable.
    '''
    InvoiceItem = apps.get_model("core", "InvoiceItem")
    db_alias = schema_editor.connection.alias

    to_update = InvoiceItem.objects.using(db_alias).filter(taxRate__isnull=True).exclude(total=0)
    to_update.update(taxRate=100 * (F('taxes') / F('total')))
    to_update = InvoiceItem.objects.using(db_alias).filter(taxRate__isnull=True)
    to_update.update(taxRate=0)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0040_invoiceitem_taxrate'),
    ]

    operations = [
        migrations.RunPython(calculate_taxrate, migrations.RunPython.noop),
    ]
