# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-25 00:10
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='DiscountCombo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Give this discount combination a name (e.g. 'Two 4-week series')", max_length=50, unique=True)),
                ('active', models.BooleanField(default=True, help_text="Uncheck this to 'turn off' this discount")),
                ('newCustomersOnly', models.BooleanField(default=False, verbose_name='Discount for New Customers only')),
                ('discountType', models.CharField(choices=[('F', 'Exact Specified Price'), ('D', 'Dollar Discount from Regular Price'), ('P', 'Percentage Discount from Regular Price'), ('A', 'Free Add-on Item (Can be combined with other discounts)')], help_text="Is this a flat price, a dollar amount discount, a 'percentage off' discount, or a free add-on?", max_length=1)),
                ('onlineStudentPrice', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Online student price')),
                ('doorStudentPrice', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='At-the-door student price')),
                ('onlineGeneralPrice', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Online general price')),
                ('doorGeneralPrice', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='At-the-door general price')),
                ('dollarDiscount', models.FloatField(blank=True, help_text="This amount will be subtracted from the customer's total (in currency units, e.g. dollars).", null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('percentDiscount', models.FloatField(blank=True, help_text="This percentage will be subtracted from the customer's total.", null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('percentUniversallyApplied', models.BooleanField(default=False, help_text='If checked, then the percentage discount will be applied to all items in the order, not just the items that qualify the order for this discount combination (e.g. 20% off all registrations of three or more classes.')),
            ],
        ),
        migrations.CreateModel(
            name='DiscountComboComponent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allWithinPointGroup', models.BooleanField(help_text='If checked, then this discount applies to this quantity or more within the point group.  Use, for example, for all-in passes.', verbose_name='Applies to all within Point Group')),
                ('quantity', models.PositiveSmallIntegerField(default=1)),
                ('weekday', models.PositiveSmallIntegerField(blank=True, choices=[(None, ''), (0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], null=True)),
                ('discountCombo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.DiscountCombo')),
                ('level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceTypeLevel')),
            ],
        ),
        migrations.CreateModel(
            name='PointGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Give this pricing tier point group a name (e.g. 'Regular Series Class Hours')", max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='PricingTierGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('points', models.PositiveIntegerField(default=0)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.PointGroup')),
                ('pricingTier', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier')),
            ],
        ),
        migrations.CreateModel(
            name='RegistrationDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('discountAmount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Amount of discount')),
                ('discount', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.DiscountCombo')),
                ('registration', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.Registration')),
            ],
        ),
        migrations.CreateModel(
            name='TemporaryRegistrationDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('discountAmount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Amount of discount')),
                ('discount', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.DiscountCombo')),
                ('registration', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration')),
            ],
        ),
        migrations.AddField(
            model_name='discountcombocomponent',
            name='pointGroup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discounts.PointGroup', verbose_name='Pricing Tier Point Group'),
        ),
        migrations.AlterUniqueTogether(
            name='pricingtiergroup',
            unique_together=set([('pricingTier', 'group')]),
        ),
    ]
