# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-08-16 02:35
from __future__ import unicode_literals

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0013_auto_20170815_2235'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('financial', '0005_auto_20170726_1350'),
    ]

    operations = [
        migrations.CreateModel(
            name='RepeatedExpenseRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rentalRate', models.FloatField(help_text='In default currency', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Expense Rate')),
                ('applyRateRule', models.CharField(choices=[('H', 'Per hour'), ('D', 'Per day of scheduled events'), ('W', 'Per week'), ('M', 'Per month'), ('N', 'Do not generate expense items for this location')], default='H', max_length=1, verbose_name='Apply this rate')),
                ('dayStarts', models.PositiveSmallIntegerField(choices=[(0, '12:00 AM'), (1, '1:00 AM'), (2, '2:00 AM'), (3, '3:00 AM'), (4, '4:00 AM'), (5, '5:00 AM'), (6, '6:00 AM'), (7, '7:00 AM'), (8, '8:00 AM'), (9, '9:00 AM'), (10, '10:00 AM'), (11, '11:00 AM'), (12, '12:00 PM'), (13, '1:00 PM'), (14, '2:00 PM'), (15, '3:00 PM'), (16, '4:00 PM'), (17, '5:00 PM'), (18, '6:00 PM'), (19, '7:00 PM'), (20, '8:00 PM'), (21, '9:00 PM'), (22, '10:00 PM'), (23, '11:00 PM')], default=0, help_text='If you run events after midnight, avoids creation of duplicate expense items', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(23)], verbose_name='Day starts at')),
                ('weekStarts', models.PositiveSmallIntegerField(choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], default=0, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(6)], verbose_name='Week starts on')),
                ('monthStarts', models.PositiveSmallIntegerField(choices=[(1, '1st'), (2, '2nd'), (3, '3rd'), (4, '4th'), (5, '5th'), (6, '6th'), (7, '7th'), (8, '8th'), (9, '9th'), (10, '10th'), (11, '11th'), (12, '12th'), (13, '13th'), (14, '14th'), (15, '15th'), (16, '16th'), (17, '17th'), (18, '18th'), (19, '19th'), (20, '20th'), (21, '21st'), (22, '22nd'), (23, '23rd'), (24, '24th'), (25, '25th'), (26, '26th'), (27, '27th'), (28, '28th')], default=1, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(28)], verbose_name='Month starts on')),
                ('startDate', models.DateField(blank=True, help_text='If specified, then expense items will not be generated prior to this date.', null=True, verbose_name='Start date')),
                ('endDate', models.DateField(blank=True, help_text='If specified, then expense items will not be generated after this date.  Leave blank for expenses to be generated indefinitely.', null=True, verbose_name='Start date')),
                ('advanceDays', models.PositiveSmallIntegerField(default=30, verbose_name='Generate expenses up to __ days in advance')),
                ('priorDays', models.PositiveSmallIntegerField(blank=True, default=180, help_text='Leave blank for no limit.', null=True, verbose_name='Generate expenses up to __ days in the past')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='expenseitem',
            name='eventstaffmember',
        ),
        migrations.RemoveField(
            model_name='expenseitem',
            name='eventvenue',
        ),
        migrations.AddField(
            model_name='expenseitem',
            name='periodEnd',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Expense period end'),
        ),
        migrations.AddField(
            model_name='expenseitem',
            name='periodStart',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Expense period start'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='category',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='financial.ExpenseCategory', verbose_name='Category'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='event',
            field=models.ForeignKey(blank=True, help_text='If this item is associated with an Event, enter it here.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.Event', verbose_name='Event'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='payToUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='payToUser', to=settings.AUTH_USER_MODEL, verbose_name='Pay to user'),
        ),
        migrations.AlterField(
            model_name='expenseitem',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='expensessubmittedby', to=settings.AUTH_USER_MODEL, verbose_name='Submission user'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='category',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='financial.RevenueCategory', verbose_name='Category'),
        ),
        migrations.AlterField(
            model_name='revenueitem',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='revenuessubmittedby', to=settings.AUTH_USER_MODEL, verbose_name='Submission user'),
        ),
        migrations.CreateModel(
            name='LocationRentalInfo',
            fields=[
                ('repeatedexpenserule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='financial.RepeatedExpenseRule')),
                ('location', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='rentalinfo', to='core.Location', verbose_name='Location')),
            ],
            options={
                'verbose_name_plural': "Locations' rental information",
                'verbose_name': 'Location rental information',
            },
            bases=('financial.repeatedexpenserule',),
        ),
        migrations.CreateModel(
            name='RoomRentalInfo',
            fields=[
                ('repeatedexpenserule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='financial.RepeatedExpenseRule')),
                ('room', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='rentalinfo', to='core.Room', verbose_name='Room')),
            ],
            options={
                'verbose_name_plural': "Rooms' rental information",
                'verbose_name': 'Room rental information',
            },
            bases=('financial.repeatedexpenserule',),
        ),
        migrations.CreateModel(
            name='StaffMemberWageInfo',
            fields=[
                ('repeatedexpenserule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='financial.RepeatedExpenseRule')),
                ('category', models.ForeignKey(blank=True, help_text='If left blank, then this expense rule will be used for all categories.  If a category-specific rate is specified, then that will be used instead.  If nothing is specified for an instructor, then the default hourly rate for each category will be used.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.EventStaffCategory', verbose_name='Category')),
                ('staffMember', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='expenserules', to='core.StaffMember', verbose_name='Staff member')),
            ],
            options={
                'verbose_name_plural': "Staff members' wage/salary information",
                'verbose_name': 'Staff member salary information',
                'ordering': ('staffMember', 'category__name'),
            },
            bases=('financial.repeatedexpenserule',),
        ),
        migrations.AddField(
            model_name='repeatedexpenserule',
            name='polymorphic_ctype',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_financial.repeatedexpenserule_set+', to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='expenseitem',
            name='expenseRule',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='financial.RepeatedExpenseRule', verbose_name='Expense generation rule'),
        ),
        migrations.AlterUniqueTogether(
            name='staffmemberwageinfo',
            unique_together=set([('staffMember', 'category')]),
        ),
    ]
