# Generated by Django 2.2.6 on 2020-01-27 14:31

from django.db import migrations, models
from django.utils.translation import gettext


def forwards_func(apps, schema_editor):
    '''
    Convert binary approval representation into something sensible in the new
    CharField.
    '''
    ExpenseItem = apps.get_model("financial", "ExpenseItem")
    db_alias = schema_editor.connection.alias

    items = ExpenseItem.objects.all()
    for item in items:
        item.approved = gettext('Approved') if item.approved == '1' else None

    ExpenseItem.objects.using(db_alias).bulk_update(items,['approved'])


def reverse_func(apps, schema_editor):
    '''
    Return approval status to a binary representation before backwards migration.
    All non-empty string values are treated as indicating approval.
    '''
    ExpenseItem = apps.get_model("financial", "ExpenseItem")
    db_alias = schema_editor.connection.alias

    items = ExpenseItem.objects.all()
    for item in items:
        item.approved = '1' if item.approved else None

    ExpenseItem.objects.using(db_alias).bulk_update(items,['approved'])


class Migration(migrations.Migration):

    dependencies = [
        ('financial', '0019_merge_20190822_2304'),
    ]

    operations = [
        migrations.AlterField(
            model_name='expenseitem',
            name='approved',
            field=models.CharField(blank=True, help_text='Indicate that expense is approved for payment, or enter any other approval status code information that is needed.', max_length=100, null=True, verbose_name='Approved'),
        ),
        migrations.RunPython(forwards_func, reverse_func)
    ]
