# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-09-05 05:49
from __future__ import unicode_literals

import cms.models.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
        ('core', '0016_auto_20170830_1159'),
    ]

    operations = [
        migrations.CreateModel(
            name='SquareCheckoutFormModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='square_squarecheckoutformmodel', serialize=False, to='cms.CMSPlugin')),
                ('defaultAmount', models.FloatField(default=0, help_text='The initial value for gift certificate forms.', verbose_name='Default amount')),
                ('successPage', cms.models.fields.PageField(help_text='When the user returns to the site after a successful transaction, send them to this page.', on_delete=django.db.models.deletion.CASCADE, related_name='successPageForSquare', to='cms.Page', verbose_name='Success Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='SquarePaymentRecord',
            fields=[
                ('paymentrecord_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.PaymentRecord')),
                ('transactionId', models.CharField(max_length=50, unique=True, verbose_name='Square Transaction ID')),
                ('locationId', models.CharField(max_length=50, verbose_name='Square Location ID')),
                ('payerEmail', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Associated email')),
            ],
            options={
                'verbose_name_plural': 'Payment records',
                'verbose_name': 'Square payment record',
                'permissions': (('handle_pos_payments', 'Has access to point-of-sale payment functionality'),),
            },
            bases=('core.paymentrecord',),
        ),
    ]
