# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-25 00:10
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CustomerRequirement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('met', models.BooleanField(default=True, help_text='If unchecked, then the customer explicitly does not meet the requirement, regardless of whether they meet its parameters.', verbose_name='Meets Requirement')),
                ('comments', models.TextField(blank=True, null=True, verbose_name='Comments/Notes')),
                ('submissionDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='Requirement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="If a customer does not meet the requirement for a series, then this description will be used to explain the issue (e.g. 'Must have taken Lindy 1 to take Lindy 2').", max_length=300, verbose_name='Requirement name/description')),
                ('booleanRule', models.CharField(choices=[('&', 'Must meet all requirement items'), ('|', 'Must meet one or more requirement items'), ('!', 'Must not meet any requirement items')], default='&', help_text="If you select an option other than 'Must meet all requirements', then you can still enforce multiple requirements by adding another Requirement item.", max_length=3, verbose_name='How many items of this requirement must be met')),
                ('enforcementMethod', models.CharField(choices=[('N', 'Enforcement disabled'), ('W', 'Allow registration with warning'), ('E', 'Raise error and do not allow registration')], default='W', max_length=1, verbose_name='Enforcement method')),
                ('roleEnforced', models.BooleanField(default=False, help_text='If checked, then in order to meet the requirement, the customer must have met all individual requirements in the same dance role, and that must be the dance role for which they are registering.', verbose_name='Same dance role enforced')),
                ('submissionDate', models.DateTimeField(auto_now_add=True, verbose_name='Submission date')),
                ('modifiedDate', models.DateTimeField(auto_now=True, verbose_name='Last modified date')),
                ('applicableClass', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.ClassDescription', verbose_name='Applies to class')),
                ('applicableLevel', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceTypeLevel', verbose_name='Applies to dance type/level')),
                ('applicableRole', models.ForeignKey(blank=True, help_text='Most requirements apply identically to all dance roles.  If this requirement does not, then specify the role to which it applies here.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole', verbose_name='Applies only to role (optional)')),
            ],
            options={
                'permissions': (('ignore_requirements', 'Can register users for series regardless of any prerequisites or requirements'),),
            },
        ),
        migrations.CreateModel(
            name='RequirementItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.PositiveSmallIntegerField(default=1, verbose_name='Quantity')),
                ('concurrentRule', models.CharField(choices=[('P', 'Must have previously taken'), ('A', 'Concurrent registration allowed'), ('R', 'Concurrent registration required')], default='P', max_length=1, verbose_name='Concurrency Rule')),
                ('requiredClass', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.ClassDescription')),
                ('requiredLevel', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceTypeLevel')),
                ('requirement', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='prerequisites.Requirement')),
            ],
        ),
        migrations.AddField(
            model_name='customerrequirement',
            name='requirement',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='prerequisites.Requirement'),
        ),
        migrations.AddField(
            model_name='customerrequirement',
            name='role',
            field=models.ForeignKey(blank=True, help_text='Role must be specified only for requirements for which roles are enforced.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole'),
        ),
        migrations.AlterUniqueTogether(
            name='customerrequirement',
            unique_together=set([('customer', 'requirement', 'role')]),
        ),
    ]
