"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestValidator = void 0;
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * @stability stable
 */
class RequestValidator extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.requestValidatorName,
        });
        const validatorProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            validateRequestBody: props.validateRequestBody,
            validateRequestParameters: props.validateRequestParameters,
        };
        const resource = new apigateway_generated_1.CfnRequestValidator(this, 'Resource', validatorProps);
        this.requestValidatorId = resource.ref;
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ validator: validatorProps });
        }
    }
    /**
     * @stability stable
     */
    static fromRequestValidatorId(scope, id, requestValidatorId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.requestValidatorId = requestValidatorId;
            }
        }
        return new Import(scope, id);
    }
}
exports.RequestValidator = RequestValidator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVxdWVzdHZhbGlkYXRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJlcXVlc3R2YWxpZGF0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBQW9EO0FBRXBELGlFQUF1RjtBQUN2Rix1Q0FBOEM7Ozs7QUErQzlDLE1BQWEsZ0JBQWlCLFNBQVEsZUFBUTs7OztJQWdCNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxLQUFLLENBQUMsb0JBQW9CO1NBQ3pDLENBQUMsQ0FBQztRQUVILE1BQU0sY0FBYyxHQUE2QjtZQUMvQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDdkIsU0FBUyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsU0FBUztZQUNsQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsbUJBQW1CO1lBQzlDLHlCQUF5QixFQUFFLEtBQUssQ0FBQyx5QkFBeUI7U0FDM0QsQ0FBQztRQUVGLE1BQU0sUUFBUSxHQUFHLElBQUksMENBQW1CLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRSxjQUFjLENBQUMsQ0FBQztRQUUzRSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUV2QyxNQUFNLFVBQVUsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLFlBQVksaUJBQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7UUFDbkcsSUFBSSxVQUFVLEVBQUU7WUFDZCxVQUFVLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUN4QyxVQUFVLENBQUMsY0FBYyxDQUFDLEVBQUUsU0FBUyxFQUFFLGNBQWMsRUFBRSxDQUFDLENBQUM7U0FDMUQ7SUFDSCxDQUFDOzs7O0lBcENNLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxrQkFBMEI7UUFDM0YsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ2tCLHVCQUFrQixHQUFHLGtCQUFrQixDQUFDO1lBQzFELENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7Q0ErQkY7QUF0Q0QsNENBc0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVJlc291cmNlLCBSZXNvdXJjZSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5SZXF1ZXN0VmFsaWRhdG9yLCBDZm5SZXF1ZXN0VmFsaWRhdG9yUHJvcHMgfSBmcm9tICcuL2FwaWdhdGV3YXkuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElSZXN0QXBpLCBSZXN0QXBpIH0gZnJvbSAnLi9yZXN0YXBpJztcblxuZXhwb3J0IGludGVyZmFjZSBJUmVxdWVzdFZhbGlkYXRvciBleHRlbmRzIElSZXNvdXJjZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVxdWVzdFZhbGlkYXRvcklkOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVxdWVzdFZhbGlkYXRvck9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXF1ZXN0VmFsaWRhdG9yTmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdmFsaWRhdGVSZXF1ZXN0Qm9keT86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycz86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVxdWVzdFZhbGlkYXRvclByb3BzIGV4dGVuZHMgUmVxdWVzdFZhbGlkYXRvck9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXN0QXBpOiBJUmVzdEFwaTtcbn1cblxuZXhwb3J0IGNsYXNzIFJlcXVlc3RWYWxpZGF0b3IgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElSZXF1ZXN0VmFsaWRhdG9yIHtcbiAgcHVibGljIHN0YXRpYyBmcm9tUmVxdWVzdFZhbGlkYXRvcklkKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlcXVlc3RWYWxpZGF0b3JJZDogc3RyaW5nKTogSVJlcXVlc3RWYWxpZGF0b3Ige1xuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVJlcXVlc3RWYWxpZGF0b3Ige1xuICAgICAgcHVibGljIHJlYWRvbmx5IHJlcXVlc3RWYWxpZGF0b3JJZCA9IHJlcXVlc3RWYWxpZGF0b3JJZDtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgcmVxdWVzdFZhbGlkYXRvcklkOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJlcXVlc3RWYWxpZGF0b3JQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy5yZXF1ZXN0VmFsaWRhdG9yTmFtZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHZhbGlkYXRvclByb3BzOiBDZm5SZXF1ZXN0VmFsaWRhdG9yUHJvcHMgPSB7XG4gICAgICBuYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICAgIHJlc3RBcGlJZDogcHJvcHMucmVzdEFwaS5yZXN0QXBpSWQsXG4gICAgICB2YWxpZGF0ZVJlcXVlc3RCb2R5OiBwcm9wcy52YWxpZGF0ZVJlcXVlc3RCb2R5LFxuICAgICAgdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVyczogcHJvcHMudmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycyxcbiAgICB9O1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuUmVxdWVzdFZhbGlkYXRvcih0aGlzLCAnUmVzb3VyY2UnLCB2YWxpZGF0b3JQcm9wcyk7XG5cbiAgICB0aGlzLnJlcXVlc3RWYWxpZGF0b3JJZCA9IHJlc291cmNlLnJlZjtcblxuICAgIGNvbnN0IGRlcGxveW1lbnQgPSAocHJvcHMucmVzdEFwaSBpbnN0YW5jZW9mIFJlc3RBcGkpID8gcHJvcHMucmVzdEFwaS5sYXRlc3REZXBsb3ltZW50IDogdW5kZWZpbmVkO1xuICAgIGlmIChkZXBsb3ltZW50KSB7XG4gICAgICBkZXBsb3ltZW50Lm5vZGUuYWRkRGVwZW5kZW5jeShyZXNvdXJjZSk7XG4gICAgICBkZXBsb3ltZW50LmFkZFRvTG9naWNhbElkKHsgdmFsaWRhdG9yOiB2YWxpZGF0b3JQcm9wcyB9KTtcbiAgICB9XG4gIH1cbn0iXX0=